<?php

namespace QuadLayers\QLWAPP_PRO;

final class Plugin {

	protected static $instance;

	private function __construct() {
		load_plugin_textdomain( 'wp-whatsapp-chat-pro', false, QLWAPP_PRO_PLUGIN_DIR . '/languages/' );
		add_action(
			'qlwapp_init',
			function () {
				/**
				 * Check if free version exists
				 */
				if ( ! class_exists( 'QuadLayers\\QLWAPP\\Plugin', false ) ) {
					return;
				}
				if ( ! class_exists( 'QuadLayers\\QLWAPP\\Controllers\\Admin_Menu', false ) ) {
					return;
				}
				/**
				 * Remove premium css
				 */
				remove_action( 'admin_footer', array( 'QuadLayers\QLWAPP\Plugin', 'add_premium_css' ) );
				/**
				 * Load classes
				 */
				Controllers\Admin_Menu::instance();
				Controllers\Customizer::instance();
				Controllers\Gutenberg::instance();
				Controllers\Frontend::instance();
				Controllers\WooCommerce::instance();
			}
		);
	}

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}

Plugin::instance();
