/* eslint-disable */
/* tslint:disable */
/**
 * This is an autogenerated file created by the Stencil compiler.
 * It contains typing information for all components that exist in this project.
 */
import { HTMLStencilElement, JSXBase } from "./stencil-public-runtime";
import { MediaCrossOriginOption, MediaPreloadOption } from "./components/providers/file/MediaFileProvider";
import { TooltipDirection, TooltipPosition } from "./components/ui/tooltip/types";
import { PlayerProp, PlayerProps } from "./components/core/player/PlayerProps";
import { Logger } from "./components/core/player/PlayerLogger";
import { Params } from "./utils/network";
import { AdapterHost, MediaProviderAdapter, MockMediaProviderAdapter } from "./components/providers/MediaProvider";
import { ViewType } from "./components/core/player/ViewType";
import { MediaResource } from "./components/providers/file/MediaResource";
import { Provider } from "./components/providers/Provider";
import { MediaType } from "./components/core/player/MediaType";
import { Translation } from "./components/core/player/lang/Translation";
import { SettingsController } from "./components/ui/settings/settings/SettingsController";
export namespace Components {
    interface VimeAudio {
        /**
          * Whether to use CORS to fetch the related image. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/crossorigin) for more information.
          * @inheritdoc
         */
        "crossOrigin"?: MediaCrossOriginOption;
        /**
          * **EXPERIMENTAL:** Whether to disable the capability of remote playback in devices that are attached using wired (HDMI, DVI, etc.) and wireless technologies (Miracast, Chromecast, DLNA, AirPlay, etc).
          * @inheritdoc
         */
        "disableRemotePlayback"?: boolean;
        "getAdapter": () => Promise<{ getInternalPlayer: () => Promise<HTMLMediaElement>; play: () => Promise<void | undefined>; pause: () => Promise<void | undefined>; canPlay: (type: any) => Promise<boolean>; setCurrentTime: (time: number) => Promise<void>; setMuted: (muted: boolean) => Promise<void>; setVolume: (volume: number) => Promise<void>; canSetPlaybackRate: () => Promise<boolean>; setPlaybackRate: (rate: number) => Promise<void>; canSetPlaybackQuality: () => Promise<boolean>; setPlaybackQuality: (quality: string) => Promise<void>; canSetPiP: () => Promise<boolean>; enterPiP: () => Promise<any>; exitPiP: () => Promise<any>; canSetFullscreen: () => Promise<boolean>; enterFullscreen: () => Promise<any>; exitFullscreen: () => Promise<any>; }>;
        /**
          * The title of the current media.
         */
        "mediaTitle"?: string;
        /**
          * Provides a hint to the browser about what the author thinks will lead to the best user experience with regards to what content is loaded before the video is played. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload) for more information.
          * @inheritdoc
         */
        "preload"?: MediaPreloadOption;
        "willAttach": boolean;
    }
    interface VimeCaptionControl {
        "currentCaption"?: PlayerProps['currentCaption'];
        /**
          * The URL to an SVG element or fragment to load.
         */
        "hideIcon": string;
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip": boolean;
        "i18n": PlayerProps['i18n'];
        "isCaptionsActive": PlayerProps['isCaptionsActive'];
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        /**
          * The URL to an SVG element or fragment to load.
         */
        "showIcon": string;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection": TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition": TooltipPosition;
    }
    interface VimeCaptions {
        /**
          * The height of any lower control bar in pixels so that the captions can reposition when it's active.
         */
        "controlsHeight": number;
        /**
          * Whether the captions should be visible or not.
         */
        "hidden": boolean;
        "isControlsActive": PlayerProps['isControlsActive'];
        "isVideoView": PlayerProps['isVideoView'];
        "playbackStarted": PlayerProps['playbackStarted'];
        "textTracks"?: PlayerProps['textTracks'];
    }
    interface VimeClickToPlay {
        "isVideoView": PlayerProps['isVideoView'];
        "paused": PlayerProps['paused'];
        /**
          * By default this is disabled on mobile to not interfere with playback, set this to `true` to enable it.
         */
        "useOnMobile": boolean;
    }
    interface VimeControl {
        /**
          * If the control has a popup menu, this indicates whether the menu is open or not. Sets the `aria-expanded` property.
         */
        "expanded"?: boolean;
        /**
          * Whether the control should be displayed or not.
         */
        "hidden": boolean;
        /**
          * The `id` attribute of the control.
         */
        "identifier"?: string;
        "isTouch": PlayerProps['isTouch'];
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        /**
          * The `aria-label` property of the control.
         */
        "label": string;
        /**
          * If the control has a popup menu, then this should be the `id` of said menu. Sets the `aria-controls` property.
         */
        "menu"?: string;
        /**
          * If the control is a toggle, this indicated whether the control is in a "pressed" state or not. Sets the `aria-pressed` property.
         */
        "pressed"?: boolean;
    }
    interface VimeControlGroup {
        /**
          * Determines where to add spacing/margin. The amount of spacing is determined by the CSS variable `--control-group-spacing`.
         */
        "space": 'top' | 'bottom' | 'both' | 'none';
    }
    interface VimeControlSpacer {
    }
    interface VimeControls {
        /**
          * The length in milliseconds that the controls are active for before fading out. Audio players are not effected by this prop.
         */
        "activeDuration": number;
        /**
          * Sets the `align-items` flex property that aligns the individual controls on the cross-axis.
         */
        "align": 'start' | 'center' | 'end';
        /**
          * Sets the `flex-direction` property that manages the direction in which the controls are layed out.
         */
        "direction": 'row' | 'column';
        /**
          * Whether the controls container should be 100% height. This has no effect if the view is of type `audio`.
         */
        "fullHeight": boolean;
        /**
          * Whether the controls container should be 100% width. This has no effect if the view is of type `audio`.
         */
        "fullWidth": boolean;
        /**
          * Whether the controls are visible or not.
         */
        "hidden": boolean;
        /**
          * Whether the controls should hide when the mouse leaves the player. Audio players are not effected by this prop.
         */
        "hideOnMouseLeave": boolean;
        /**
          * Whether the controls should show/hide when paused. Audio players are not effected by this prop.
         */
        "hideWhenPaused": boolean;
        "isAudioView": PlayerProps['isAudioView'];
        "isControlsActive": PlayerProps['isControlsActive'];
        "isSettingsActive": PlayerProps['isSettingsActive'];
        /**
          * Sets the `justify-content` flex property that aligns the individual controls on the main-axis.
         */
        "justify": 'start'
  | 'center'
  | 'end'
  | 'space-around'
  | 'space-between'
  | 'space-evenly';
        "paused": PlayerProps['paused'];
        /**
          * Pins the controls to the defined position inside the video player. This has no effect when the view is of type `audio`.
         */
        "pin": 'topLeft' | 'topRight' | 'bottomLeft' | 'bottomRight' | 'center';
        "playbackReady": PlayerProps['playbackReady'];
        "playbackStarted": PlayerProps['playbackStarted'];
        /**
          * Whether the controls should wait for playback to start before being shown. Audio players are not effected by this prop.
         */
        "waitForPlaybackStart": boolean;
    }
    interface VimeCurrentTime {
        /**
          * Whether the time should always show the hours unit, even if the time is less than 1 hour (eg: `20:35` -> `00:20:35`).
         */
        "alwaysShowHours": boolean;
        "currentTime": PlayerProps['currentTime'];
        "i18n": PlayerProps['i18n'];
    }
    interface VimeDailymotion {
        "autoplay": boolean;
        /**
          * Change the default highlight color used in the controls (hex value without the leading #). Color set in the Partner HQ will override this prop.
         */
        "color"?: string;
        "controls": boolean;
        "getAdapter": () => Promise<{ getInternalPlayer: () => Promise<HTMLVimeEmbedElement>; play: () => Promise<void>; pause: () => Promise<void>; canPlay: (type: any) => Promise<boolean>; setCurrentTime: (time: number) => Promise<void>; setMuted: (muted: boolean) => Promise<void>; setVolume: (volume: number) => Promise<void>; canSetPlaybackQuality: () => Promise<boolean>; setPlaybackQuality: (quality: string) => Promise<void>; canSetFullscreen: () => Promise<boolean>; enterFullscreen: () => Promise<void>; exitFullscreen: () => Promise<void>; }>;
        "language": string;
        "logger"?: Logger;
        "loop": boolean;
        "muted": boolean;
        "playsinline": boolean;
        /**
          * The absolute URL of a custom poster to be used for the current video.
         */
        "poster"?: string;
        /**
          * Whether to automatically play the next video in the queue.
         */
        "shouldAutoplayQueue": boolean;
        /**
          * Whether to display the Dailymotion logo.
         */
        "showDailymotionLogo": boolean;
        /**
          * Whether to show buttons for sharing the video.
         */
        "showShareButtons": boolean;
        /**
          * Whether to show the 'Up Next' queue.
         */
        "showUpNextQueue": boolean;
        /**
          * Whether to show video information (title and owner) on the start screen.
         */
        "showVideoInfo": boolean;
        /**
          * Forwards your syndication key to the player.
         */
        "syndication"?: string;
        /**
          * The Dailymotion resource ID of the video to load.
         */
        "videoId": string;
    }
    interface VimeDash {
        /**
          * **EXPERIMENTAL:** Whether the browser should automatically toggle picture-in-picture mode as the user switches back and forth between this document and another document or application.
          * @inheritdoc
         */
        "autoPiP"?: boolean;
        "autoplay": boolean;
        /**
          * The `dashjs` configuration.
         */
        "config": Record<string, any>;
        /**
          * Determines what controls to show on the media element whenever the browser shows its own set of controls (e.g. when the controls attribute is specified).
          * @inheritdoc
         */
        "controlsList"?: string;
        /**
          * Whether to use CORS to fetch the related image. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/crossorigin) for more information.
          * @inheritdoc
         */
        "crossOrigin"?: MediaCrossOriginOption;
        /**
          * **EXPERIMENTAL:** Prevents the browser from suggesting a picture-in-picture context menu or to request picture-in-picture automatically in some cases.
          * @inheritdoc
         */
        "disablePiP"?: boolean;
        /**
          * **EXPERIMENTAL:** Whether to disable the capability of remote playback in devices that are attached using wired (HDMI, DVI, etc.) and wireless technologies (Miracast, Chromecast, DLNA, AirPlay, etc).
          * @inheritdoc
         */
        "disableRemotePlayback"?: boolean;
        "getAdapter": () => Promise<{ getInternalPlayer: () => Promise<any>; canPlay: (type: any) => Promise<boolean>; play: () => Promise<void | undefined>; pause: () => Promise<void | undefined>; setCurrentTime: (time: number) => Promise<void>; setMuted: (muted: boolean) => Promise<void>; setVolume: (volume: number) => Promise<void>; canSetPlaybackRate: () => Promise<boolean>; setPlaybackRate: (rate: number) => Promise<void>; canSetPlaybackQuality: () => Promise<boolean>; setPlaybackQuality: (quality: string) => Promise<void>; canSetPiP: () => Promise<boolean>; enterPiP: () => Promise<any>; exitPiP: () => Promise<any>; canSetFullscreen: () => Promise<boolean>; enterFullscreen: () => Promise<any>; exitFullscreen: () => Promise<any>; }>;
        /**
          * The title of the current media.
         */
        "mediaTitle"?: string;
        /**
          * A URL for an image to be shown while the video is downloading. If this attribute isn't specified, nothing is displayed until the first frame is available, then the first frame is shown as the poster frame.
          * @inheritdoc
         */
        "poster"?: string;
        /**
          * Provides a hint to the browser about what the author thinks will lead to the best user experience with regards to what content is loaded before the video is played. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload) for more information.
          * @inheritdoc
         */
        "preload"?: MediaPreloadOption;
        /**
          * The URL of the `manifest.mpd` file to use.
         */
        "src": string;
        /**
          * The NPM package version of the `dashjs` library to download and use.
         */
        "version": string;
    }
    interface VimeDblClickFullscreen {
        "isFullscreenActive": PlayerProps['isFullscreenActive'];
        "isVideoView": PlayerProps['isVideoView'];
        "playbackReady": PlayerProps['playbackReady'];
        /**
          * By default this is disabled on mobile to not interfere with playback, set this to `true` to enable it.
         */
        "useOnMobile": boolean;
    }
    interface VimeDefaultControls {
        /**
          * The length in milliseconds that the controls are active for before fading out. Audio players are not effected by this prop.
         */
        "activeDuration": number;
        /**
          * Whether the controls should hide when the mouse leaves the player. Audio players are not effected by this prop.
         */
        "hideOnMouseLeave": boolean;
        /**
          * Whether the controls should show/hide when paused. Audio players are not effected by this prop.
         */
        "hideWhenPaused": boolean;
        "isAudioView": PlayerProps['isAudioView'];
        "isLive": PlayerProps['isLive'];
        "isMobile": PlayerProps['isMobile'];
        "isVideoView": PlayerProps['isVideoView'];
        "theme"?: PlayerProps['theme'];
        /**
          * Whether the controls should wait for playback to start before being shown. Audio players are not effected by this prop.
         */
        "waitForPlaybackStart": boolean;
    }
    interface VimeDefaultSettings {
        "currentCaption"?: PlayerProps['currentCaption'];
        "i18n": PlayerProps['i18n'];
        "isCaptionsActive": PlayerProps['isCaptionsActive'];
        /**
          * Pins the settings to the defined position inside the video player. This has no effect when the view is of type `audio`, it will always be `bottomRight`.
         */
        "pin": 'topLeft' | 'topRight' | 'bottomLeft' | 'bottomRight';
        "playbackQualities": PlayerProps['playbackQualities'];
        "playbackQuality"?: PlayerProps['playbackQuality'];
        "playbackRate": PlayerProps['playbackRate'];
        "playbackRates": PlayerProps['playbackRates'];
        "playbackReady": PlayerProps['playbackReady'];
        "textTracks"?: PlayerProps['textTracks'];
    }
    interface VimeDefaultUi {
        /**
          * Whether the custom captions UI should not be loaded.
         */
        "noCaptions": boolean;
        /**
          * Whether clicking the player should not toggle playback.
         */
        "noClickToPlay": boolean;
        /**
          * Whether the custom default controls should not be loaded.
         */
        "noControls": boolean;
        /**
          * Whether double clicking the player should not toggle fullscreen mode.
         */
        "noDblClickFullscreen": boolean;
        /**
          * Whether the default icons should not be loaded.
         */
        "noIcons": boolean;
        /**
          * Whether the custom poster UI should not be loaded.
         */
        "noPoster": boolean;
        /**
          * Whether the custom default settings menu should not be loaded.
         */
        "noSettings": boolean;
        /**
          * Whether the skeleton loading animation should be shown while the player is loading.
         */
        "noSkeleton": boolean;
        /**
          * Whether the custom spinner UI should not be loaded.
         */
        "noSpinner": boolean;
    }
    interface VimeEmbed {
        /**
          * A function which accepts the raw message received from the embedded media player via `postMessage` and converts it into a POJO.
         */
        "decoder"?: (data: string) => Params | undefined;
        /**
          * A URL that will load the external player and media (Eg: https://www.youtube.com/embed/DyTCOwB0DVw).
         */
        "embedSrc": string;
        /**
          * The title of the current media so it can be set on the inner `iframe` for screen readers.
         */
        "mediaTitle": string;
        /**
          * Where the src request had originated from without any path information.
         */
        "origin"?: string;
        /**
          * The parameters to pass to the embedded player which are appended to the `embedSrc` prop. These can be passed in as a query string or object.
         */
        "params": string | Params;
        /**
          * Posts a message to the embedded media player.
         */
        "postMessage": (message: any, target?: string | undefined) => Promise<void>;
        /**
          * A collection of URLs to that the browser should immediately start establishing a connection with.
         */
        "preconnections": string[];
    }
    interface VimeEndTime {
        /**
          * Whether the time should always show the hours unit, even if the time is less than 1 hour (eg: `20:35` -> `00:20:35`).
         */
        "alwaysShowHours": boolean;
        "duration": PlayerProps['duration'];
        "i18n": PlayerProps['i18n'];
    }
    interface VimeFaketube {
        "autoplay": boolean;
        "controls": boolean;
        /**
          * Dispatches a state change event.
         */
        "dispatchChange": (prop: PlayerProp, value: any) => Promise<void>;
        /**
          * Dispatches the `vLoadStart` event.
         */
        "dispatchLoadStart": () => Promise<void>;
        /**
          * Returns a mock adapter.
         */
        "getAdapter": () => Promise<MockMediaProviderAdapter>;
        "language": string;
        "logger"?: Logger;
        "loop": boolean;
        "muted": boolean;
        "playsinline": boolean;
    }
    interface VimeFile {
        /**
          * **EXPERIMENTAL:** Whether the browser should automatically toggle picture-in-picture mode as the user switches back and forth between this document and another document or application.
          * @inheritdoc
         */
        "autoPiP"?: boolean;
        "autoplay": boolean;
        "controls": boolean;
        /**
          * Determines what controls to show on the media element whenever the browser shows its own set of controls (e.g. when the controls attribute is specified).
          * @inheritdoc
         */
        "controlsList"?: string;
        /**
          * Whether to use CORS to fetch the related image. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/crossorigin) for more information.
          * @inheritdoc
         */
        "crossOrigin"?: MediaCrossOriginOption;
        "currentTime": number;
        /**
          * **EXPERIMENTAL:** Prevents the browser from suggesting a picture-in-picture context menu or to request picture-in-picture automatically in some cases.
          * @inheritdoc
         */
        "disablePiP"?: boolean;
        /**
          * **EXPERIMENTAL:** Whether to disable the capability of remote playback in devices that are attached using wired (HDMI, DVI, etc.) and wireless technologies (Miracast, Chromecast, DLNA, AirPlay, etc).
          * @inheritdoc
         */
        "disableRemotePlayback"?: boolean;
        "getAdapter": () => Promise<{ getInternalPlayer: () => Promise<HTMLMediaElement>; play: () => Promise<void | undefined>; pause: () => Promise<void | undefined>; canPlay: (type: any) => Promise<boolean>; setCurrentTime: (time: number) => Promise<void>; setMuted: (muted: boolean) => Promise<void>; setVolume: (volume: number) => Promise<void>; canSetPlaybackRate: () => Promise<boolean>; setPlaybackRate: (rate: number) => Promise<void>; canSetPlaybackQuality: () => Promise<boolean>; setPlaybackQuality: (quality: string) => Promise<void>; canSetPiP: () => Promise<boolean>; enterPiP: () => Promise<any>; exitPiP: () => Promise<any>; canSetFullscreen: () => Promise<boolean>; enterFullscreen: () => Promise<any>; exitFullscreen: () => Promise<any>; }>;
        "language": string;
        "logger"?: Logger;
        "loop": boolean;
        /**
          * The title of the current media.
         */
        "mediaTitle"?: string;
        "muted": boolean;
        "noConnect": boolean;
        "paused": boolean;
        /**
          * The playback rates that are available for this media.
         */
        "playbackRates": number[];
        "playbackStarted": boolean;
        "playsinline": boolean;
        /**
          * A URL for an image to be shown while the video is downloading. If this attribute isn't specified, nothing is displayed until the first frame is available, then the first frame is shown as the poster frame.
          * @inheritdoc
         */
        "poster"?: string;
        /**
          * Provides a hint to the browser about what the author thinks will lead to the best user experience with regards to what content is loaded before the video is played. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload) for more information.
          * @inheritdoc
         */
        "preload"?: MediaPreloadOption;
        /**
          * Whether to use an `audio` or `video` element to play the media.
         */
        "viewType"?: ViewType;
        "willAttach": boolean;
    }
    interface VimeFullscreenControl {
        /**
          * The URL to an SVG element or fragment to display for entering fullscreen.
         */
        "enterIcon": string;
        /**
          * The URL to an SVG element or fragment to display for exiting fullscreen.
         */
        "exitIcon": string;
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip": boolean;
        "i18n": PlayerProps['i18n'];
        "isFullscreenActive": PlayerProps['isFullscreenActive'];
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        "playbackReady": PlayerProps['playbackReady'];
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection": TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition": TooltipPosition;
    }
    interface VimeHls {
        /**
          * **EXPERIMENTAL:** Whether the browser should automatically toggle picture-in-picture mode as the user switches back and forth between this document and another document or application.
          * @inheritdoc
         */
        "autoPiP"?: boolean;
        /**
          * The `hls.js` configuration.
         */
        "config"?: any;
        /**
          * Determines what controls to show on the media element whenever the browser shows its own set of controls (e.g. when the controls attribute is specified).
          * @inheritdoc
         */
        "controlsList"?: string;
        /**
          * Whether to use CORS to fetch the related image. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/crossorigin) for more information.
          * @inheritdoc
         */
        "crossOrigin"?: MediaCrossOriginOption;
        /**
          * **EXPERIMENTAL:** Prevents the browser from suggesting a picture-in-picture context menu or to request picture-in-picture automatically in some cases.
          * @inheritdoc
         */
        "disablePiP"?: boolean;
        /**
          * **EXPERIMENTAL:** Whether to disable the capability of remote playback in devices that are attached using wired (HDMI, DVI, etc.) and wireless technologies (Miracast, Chromecast, DLNA, AirPlay, etc).
          * @inheritdoc
         */
        "disableRemotePlayback"?: boolean;
        "getAdapter": () => Promise<{ getInternalPlayer: () => Promise<any>; canPlay: (type: any) => Promise<boolean>; play: () => Promise<void | undefined>; pause: () => Promise<void | undefined>; setCurrentTime: (time: number) => Promise<void>; setMuted: (muted: boolean) => Promise<void>; setVolume: (volume: number) => Promise<void>; canSetPlaybackRate: () => Promise<boolean>; setPlaybackRate: (rate: number) => Promise<void>; canSetPlaybackQuality: () => Promise<boolean>; setPlaybackQuality: (quality: string) => Promise<void>; canSetPiP: () => Promise<boolean>; enterPiP: () => Promise<any>; exitPiP: () => Promise<any>; canSetFullscreen: () => Promise<boolean>; enterFullscreen: () => Promise<any>; exitFullscreen: () => Promise<any>; }>;
        /**
          * The title of the current media.
         */
        "mediaTitle"?: string;
        /**
          * A URL for an image to be shown while the video is downloading. If this attribute isn't specified, nothing is displayed until the first frame is available, then the first frame is shown as the poster frame.
          * @inheritdoc
         */
        "poster"?: string;
        /**
          * Provides a hint to the browser about what the author thinks will lead to the best user experience with regards to what content is loaded before the video is played. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload) for more information.
          * @inheritdoc
         */
        "preload"?: MediaPreloadOption;
        /**
          * The NPM package version of the `hls.js` library to download and use if HLS is not natively supported.
         */
        "version": string;
    }
    interface VimeIcon {
        /**
          * The URL to an SVG element or fragment to load.
         */
        "href"?: string;
    }
    interface VimeIcons {
        /**
          * The URL to an SVG sprite to load.
         */
        "href": string;
    }
    interface VimeLiveIndicator {
        "i18n": PlayerProps['i18n'];
        "isLive": PlayerProps['isLive'];
    }
    interface VimeMenu {
        /**
          * Whether the menu is open/visible.
         */
        "active": boolean;
        /**
          * The `id` attribute value of the control responsible for opening/closing this menu.
         */
        "controller": string;
        /**
          * This should be called directly before opening the menu to set the keyboard focus on it. This is a one-time operation and needs to be called everytime prior to opening the menu.
         */
        "focusOnOpen": () => Promise<void>;
        /**
          * Returns the controller responsible for opening/closing this menu.
         */
        "getController": () => Promise<HTMLElement>;
        /**
          * Returns the currently focused menu item.
         */
        "getFocusedMenuItem": () => Promise<HTMLVimeMenuItemElement>;
        /**
          * The `id` attribute of the menu.
         */
        "identifier": string;
    }
    interface VimeMenuItem {
        /**
          * This can provide additional context about the value of a menu item. For example, if the item is a radio button for a set of video qualities, the badge could describe whether the quality is UHD, HD etc.
         */
        "badge"?: string;
        /**
          * If this item is to behave as a radio button, then this property determines whether the radio is selected or not. Sets the `aria-checked` property.
         */
        "checked"?: boolean;
        /**
          * The URL to an SVG element or fragment to load.
         */
        "checkedIcon"?: string;
        /**
          * If the item has a popup menu, this indicates whether the menu is open or not. Sets the `aria-expanded` property.
         */
        "expanded"?: boolean;
        /**
          * Whether the item is displayed or not.
         */
        "hidden": boolean;
        /**
          * This can provide additional context about some underlying state of the item. For example, if the menu item opens/closes a submenu with options, the hint could be the currently selected option.
         */
        "hint"?: string;
        /**
          * The `id` attribute of the item.
         */
        "identifier"?: string;
        "isTouch": PlayerProps['isTouch'];
        /**
          * The label/title of the item.
         */
        "label": string;
        /**
          * If the item has a popup menu, then this should be the `id` of said menu. Sets the `aria-controls` property.
         */
        "menu"?: string;
    }
    interface VimeMenuRadio {
        /**
          * This can provide additional context about the value. For example, if the option is for a set of video qualities, the badge could describe whether the quality is UHD, HD etc.
         */
        "badge"?: string;
        /**
          * Whether the radio item is selected or not.
         */
        "checked": boolean;
        /**
          * The URL to an SVG element or fragment to load.
         */
        "checkedIcon"?: string;
        /**
          * The title of the radio item displayed to the user.
         */
        "label": string;
        /**
          * The value associated with this radio item.
         */
        "value": string;
    }
    interface VimeMenuRadioGroup {
        /**
          * The current value selected for this group.
         */
        "value"?: string;
    }
    interface VimeMuteControl {
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip": boolean;
        /**
          * The URL to an SVG element or fragment.
         */
        "highVolumeIcon": string;
        "i18n": PlayerProps['i18n'];
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        /**
          * The URL to an SVG element or fragment.
         */
        "lowVolumeIcon": string;
        "muted": PlayerProps['muted'];
        /**
          * The URL to an SVG element or fragment.
         */
        "mutedIcon": string;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection": TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition": TooltipPosition;
        "volume": PlayerProps['volume'];
    }
    interface VimePipControl {
        /**
          * The URL to an SVG element or fragment to display for entering PiP.
         */
        "enterIcon": string;
        /**
          * The URL to an SVG element or fragment to display for exiting PiP.
         */
        "exitIcon": string;
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip": boolean;
        "i18n": PlayerProps['i18n'];
        "isPiPActive": PlayerProps['isPiPActive'];
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        "playbackReady": PlayerProps['playbackReady'];
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection": TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition": TooltipPosition;
    }
    interface VimePlaybackControl {
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip": boolean;
        "i18n": PlayerProps['i18n'];
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        /**
          * The URL to an SVG element or fragment to load.
         */
        "pauseIcon": string;
        "paused": PlayerProps['paused'];
        /**
          * The URL to an SVG element or fragment to load.
         */
        "playIcon": string;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection": TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition": TooltipPosition;
    }
    interface VimePlayer {
        /**
          * The aspect ratio of the player expressed as `width:height` (`16:9`). This is only applied if the `viewType` is `video` and the player is not in fullscreen mode.
          * @inheritDoc
         */
        "aspectRatio": string;
        /**
          * `@readonly` Whether the player is attached to the DOM.
          * @inheritDoc
         */
        "attached": boolean;
        /**
          * Whether the player should automatically pause when another Vime player starts/resumes playback.
          * @inheritDoc
         */
        "autopause": boolean;
        /**
          * Whether playback should automatically begin playing once the media is ready to do so. This will only work if the browsers `autoplay` policies have been satisfied. It'll generally work if the player is muted, or the user frequently interacts with your site. You can check if it's possible to autoplay via the `canAutoplay()` or `canMutedAutoplay()` methods. Depending on the provider, changing this prop may cause the player to completely reset.
          * @inheritDoc
         */
        "autoplay": boolean;
        /**
          * `@readonly` The length of the media in seconds that has been downloaded by the browser.
          * @inheritDoc
         */
        "buffered": number;
        /**
          * `@readonly` Whether playback has temporarily stopped because of a lack of temporary data.
          * @inheritDoc
         */
        "buffering": boolean;
        "callAdapter": (method: keyof MediaProviderAdapter, value?: any) => Promise<any>;
        /**
          * Determines whether the player can start playback of the current media automatically.
          * @inheritDoc
         */
        "canAutoplay": () => Promise<boolean>;
        /**
          * Determines whether the player can start playback of the current media automatically given the player is muted.
          * @inheritDoc
         */
        "canMutedAutoplay": () => Promise<boolean>;
        /**
          * Determines whether the current provider recognizes, and can play the given type.
          * @inheritDoc
         */
        "canPlay": (type: string) => Promise<boolean>;
        /**
          * Returns whether the native browser fullscreen API is available, or the current provider can toggle fullscreen mode. This does not mean that the operation is guaranteed to be successful, only that it can be attempted.
          * @inheritDoc
         */
        "canSetFullscreen": () => Promise<boolean>;
        /**
          * Returns whether the current provider exposes an API for entering and exiting picture-in-picture mode. This does not mean the operation is guaranteed to be successful, only that it can be attempted.
          * @inheritDoc
         */
        "canSetPiP": () => Promise<boolean>;
        /**
          * Returns whether the current provider allows setting the `playbackQuality` prop.
          * @inheritDoc
         */
        "canSetPlaybackQuality": () => Promise<boolean>;
        /**
          * Returns whether the current provider allows setting the `playbackRate` prop.
          * @inheritDoc
         */
        "canSetPlaybackRate": () => Promise<boolean>;
        /**
          * Indicates whether a user interface should be shown for controlling the resource. Set this to `false` when you want to provide your own custom controls, and `true` if you want the current provider to supply its own default controls. Depending on the provider, changing this prop may cause the player to completely reset.
          * @inheritDoc
         */
        "controls": boolean;
        /**
          * `@readonly` The selected caption/subtitle text track to display. Defaults to `undefined` if there is none. This does not mean this track is active, only that is the current selection. To know if it is active, check the `isCaptionsActive` prop.
          * @inheritDoc
         */
        "currentCaption"?: TextTrack;
        /**
          * `@readonly` The absolute URL of the poster for the current media resource. Defaults to `undefined` if no media/poster has been loaded.
          * @inheritDoc
         */
        "currentPoster"?: string;
        /**
          * `@readonly` The current provider name whose responsible for loading and playing media. Defaults to `undefined` when no provider has been loaded.
          * @inheritDoc
         */
        "currentProvider"?: Provider;
        /**
          * `@readonly` The absolute URL of the media resource that has been chosen. Defaults to `undefined` if no media has been loaded.
          * @inheritDoc
         */
        "currentSrc"?: string;
        /**
          * A `double` indicating the current playback time in seconds. Defaults to `0` if the media has not started to play and has not seeked. Setting this value seeks the media to the new time. The value can be set to a minimum of `0` and maximum of the total length of the media (indicated by the duration prop).
          * @inheritDoc
         */
        "currentTime": number;
        /**
          * `@readonly` Whether the player is in debug mode and should `console.x` information about its internal state.
          * @inheritDoc
         */
        "debug": boolean;
        /**
          * `@readonly` A `double` indicating the total playback length of the media in seconds. Defaults to `-1` if no media has been loaded. If the media is being streamed live then the duration is equal to `Infinity`.
          * @inheritDoc
         */
        "duration": number;
        /**
          * Requests to enter fullscreen mode, returning a `Promise` that will resolve if the request is made, or reject with a reason for failure. This method will first attempt to use the browsers native fullscreen API, and then fallback to requesting the provider to do it (if available). Do not rely on a resolved promise to determine if the player is in fullscreen or not. The only way to be certain is by listening to the `vFullscreenChange` event. Some common reasons for failure are: the fullscreen API is not available, the request is made when `viewType` is audio, or the user has not interacted with the page yet.
          * @inheritDoc
         */
        "enterFullscreen": (options?: FullscreenOptions | undefined) => Promise<any>;
        /**
          * Request to enter picture-in-picture (PiP) mode, returning a `Promise` that will resolve if the request is made, or reject with a reason for failure. Do not rely on a resolved promise to determine if the player is in PiP mode or not. The only way to be certain is by listening to the `vPiPChange` event. Some common reasons for failure are the same as the reasons for `enterFullscreen()`.
          * @inheritDoc
         */
        "enterPiP": () => Promise<void | undefined>;
        /**
          * `@readonly` A collection of errors that have occurred ordered by `[oldest, ..., newest]`.
          * @inheritDoc
         */
        "errors": any[];
        /**
          * Requests to exit fullscreen mode, returning a `Promise` that will resolve if the request is successful, or reject with a reason for failure. Refer to `enterFullscreen()` for more information.
          * @inheritDoc
         */
        "exitFullscreen": () => Promise<any>;
        /**
          * Request to exit picture-in-picture mode, returns a `Promise` that will resolve if the request is successful, or reject with a reason for failure. Refer to `enterPiP()` for more information.
          * @inheritDoc
         */
        "exitPiP": () => Promise<void | undefined>;
        /**
          * Extends the translation map for a given language.
          * @inheritDoc
         */
        "extendLanguage": (language: string, translation: Partial<Translation>) => Promise<void>;
        /**
          * Returns the current media provider's adapter. Shorthand for `getProvider().getAdapter()`.
         */
        "getAdapter": <InternalPlayerType = any>() => Promise<MediaProviderAdapter<InternalPlayerType> | undefined>;
        /**
          * Returns the current media provider.
          * @inheritDoc
         */
        "getProvider": <InternalPlayerType = any>() => Promise<AdapterHost<InternalPlayerType> | undefined>;
        /**
          * `@readonly` A dictionary of translations for the current language.
          * @inheritDoc
         */
        "i18n": Translation;
        /**
          * `@readonly` Whether the current media is of type `audio`, shorthand for `mediaType === MediaType.Audio`.
          * @inheritDoc
         */
        "isAudio": boolean;
        /**
          * `@readonly` Whether the current view is of type `audio`, shorthand for `viewType === ViewType.Audio`.
          * @inheritDoc
         */
        "isAudioView": boolean;
        /**
          * `@readonly` Whether any captions or subtitles are currently showing.
          * @inheritDoc
         */
        "isCaptionsActive": boolean;
        /**
          * Whether the controls are currently visible. This is currently only supported by custom controls.
          * @inheritDoc
         */
        "isControlsActive": boolean;
        /**
          * `@readonly` Whether the player is currently in fullscreen mode.
          * @inheritDoc
         */
        "isFullscreenActive": boolean;
        /**
          * `@readonly` Whether the current media is being broadcast live (`duration === Infinity`).
          * @inheritDoc
         */
        "isLive": boolean;
        /**
          * `@readonly` Whether the player is in mobile mode. This is determined by parsing `window.navigator.userAgent`.
          * @inheritDoc
         */
        "isMobile": boolean;
        /**
          * `@readonly` Whether the player is currently in picture-in-picture mode.
          * @inheritDoc
         */
        "isPiPActive": boolean;
        /**
          * `@readonly` Whether the settings menu has been opened and is currently visible. This is currently only supported by custom settings.
          * @inheritDoc
         */
        "isSettingsActive": boolean;
        /**
          * `@readonly` Whether the player is in touch mode. This is determined by listening for mouse/touch events and toggling this value.
          * @inheritDoc
         */
        "isTouch": boolean;
        /**
          * `@readonly` Whether the current media is of type `video`, shorthand for `mediaType === MediaType.Video`.
          * @inheritDoc
         */
        "isVideo": boolean;
        /**
          * `@readonly` Whether the current view is of type `video`, shorthand for `viewType === ViewType.Video`.
          * @inheritDoc
         */
        "isVideoView": boolean;
        /**
          * The current language of the player. This can be any code defined via the `extendLanguage` method or the default `en`. It's recommended to use an ISO 639-1 code as that'll be used by Vime when adding new language defaults in the future.
          * @inheritDoc
         */
        "language": string;
        /**
          * `@readonly` The languages that are currently available. You can add new languages via the `extendLanguage` method.
          * @inheritDoc
         */
        "languages": string[];
        "logger": Logger;
        /**
          * Whether media should automatically start playing from the beginning every time it ends.
          * @inheritDoc
         */
        "loop": boolean;
        /**
          * `@readonly` The title of the current media. Defaults to `undefined` if no media has been loaded.
          * @inheritDoc
         */
        "mediaTitle"?: string;
        /**
          * `@readonly` The type of media that is currently active, whether it's audio or video. Defaults to `undefined` when no media has been loaded or the type cannot be determined.
          * @inheritDoc
         */
        "mediaType"?: MediaType;
        /**
          * Whether the audio is muted or not.
          * @inheritDoc
         */
        "muted": boolean;
        /**
          * Pauses playback of the media.
          * @inheritDoc
         */
        "pause": () => Promise<void | undefined>;
        /**
          * Whether playback should be paused. Defaults to `true` if no media has loaded or playback has not started. Setting this to `true` will begin/resume playback.
          * @inheritDoc
         */
        "paused": boolean;
        /**
          * Begins/resumes playback of the media. If this method is called programmatically before the user has interacted with the player, the promise may be rejected subject to the browser's autoplay policies.
          * @inheritDoc
         */
        "play": () => Promise<void | undefined>;
        /**
          * `@readonly` Whether media playback has reached the end. In other words it'll be true if `currentTime === duration`.
          * @inheritDoc
         */
        "playbackEnded": boolean;
        /**
          * `@readonly` The media qualities available for the current media.
          * @inheritDoc
         */
        "playbackQualities": string[];
        /**
          * Indicates the quality of the media. The value will differ between audio and video. For audio this might be some combination of the encoding format (AAC, MP3), bitrate in kilobits per second (kbps) and sample rate in kilohertz (kHZ). For video this will be the number of vertical pixels it supports. For example, if the video has a resolution of `1920x1080` then the quality will return `1080p`. Defaults to `undefined` which you can interpret as the quality is unknown. The quality can only be set to a quality found in the `playbackQualities` prop. Some providers may not allow changing the quality, you can check if it's possible via `canSetPlaybackQuality()`.
          * @inheritDoc
         */
        "playbackQuality"?: string;
        /**
          * A `double` indicating the rate at which media is being played back. If the value is `<1` then playback is slowed down; if `>1` then playback is sped up. Defaults to `1`. The playback rate can only be set to a rate found in the `playbackRates` prop. Some providers may not allow changing the playback rate, you can check if it's possible via `canSetPlaybackRate()`.
          * @inheritDoc
         */
        "playbackRate": number;
        /**
          * `@readonly` The playback rates available for the current media.
          * @inheritDoc
         */
        "playbackRates": number[];
        /**
          * `@readonly` Whether media is ready for playback to begin.
          * @inheritDoc
         */
        "playbackReady": boolean;
        /**
          * `@readonly` Whether the media has initiated playback. In other words it will be true if `currentTime > 0`.
          * @inheritDoc
         */
        "playbackStarted": boolean;
        /**
          * `@readonly` Whether media is actively playing back. Defaults to `false` if no media has loaded or playback has not started.
          * @inheritDoc
         */
        "playing": boolean;
        /**
          * Whether the video is to be played "inline", that is within the element's playback area. Note that setting this to false does not imply that the video will always be played in fullscreen. Depending on the provider, changing this prop may cause the player to completely reset.
          * @inheritDoc
         */
        "playsinline": boolean;
        /**
          * `@readonly` Whether the player has loaded and is ready to be interacted with.
          * @inheritDoc
         */
        "ready": boolean;
        /**
          * `@readonly` Whether the player is in the process of seeking to a new time position.
          * @inheritDoc
         */
        "seeking": boolean;
        "setProvider": (provider: AdapterHost) => Promise<void>;
        /**
          * `@readonly` The text tracks (WebVTT) associated with the current media.
          * @inheritDoc
         */
        "textTracks"?: TextTrackList;
        /**
          * This property has no role other than scoping CSS selectors.
          * @inheritDoc
         */
        "theme"?: string;
        /**
          * Toggles the visibility of the captions.
          * @inheritdoc
         */
        "toggleCaptionsVisibility": (isVisible?: boolean | undefined) => Promise<void>;
        /**
          * `@readonly` Contains each language and its respective translation map.
          * @inheritDoc
         */
        "translations": Record<string, Translation>;
        /**
          * `@readonly` The type of player view that is being used, whether it's an audio player view or video player view. Normally if the media type is of audio then the view is of type audio, but in some cases it might be desirable to show a different view type. For example, when playing audio with a poster. This is subject to the provider allowing it. Defaults to `undefined` when no media has been loaded.
          * @inheritDoc
         */
        "viewType"?: ViewType;
        /**
          * An `int` between `0` (silent) and `100` (loudest) indicating the audio volume.
          * @inheritDoc
         */
        "volume": number;
    }
    interface VimePlayground {
        /**
          * The current poster to load.
         */
        "poster": string;
        /**
          * The current media provider.
         */
        "provider": Provider;
        /**
          * Whether to show the custom Vime UI or not.
         */
        "showCustomUI": boolean;
        /**
          * The current `src` to load into the provider.
         */
        "src"?: string;
        /**
          * The current custom UI theme, won't work if custom UI is turned off.
         */
        "theme": 'light' | 'dark';
    }
    interface VimePoster {
        "currentPoster"?: PlayerProps['currentPoster'];
        "currentTime": PlayerProps['currentTime'];
        /**
          * How the poster image should be resized to fit the container (sets the `object-fit` property).
         */
        "fit"?: 'fill' | 'contain' | 'cover' | 'scale-down' | 'none';
        "isVideoView": PlayerProps['isVideoView'];
        "mediaTitle"?: PlayerProps['mediaTitle'];
        "playbackStarted": PlayerProps['playbackStarted'];
    }
    interface VimeScrim {
        /**
          * If this prop is defined, a dark gradient that smoothly fades out without being noticed will be used instead of a set color. This prop also sets the direction in which the dark end of the gradient should start. If the direction is set to `up`, the dark end of the gradient will start at the bottom of the player and fade out to the center. If the direction is set to `down`, the gradient will start at the top of the player and fade out to the center.
         */
        "gradient"?: 'up' | 'down';
        "isControlsActive": PlayerProps['isControlsActive'];
        "isVideoView": PlayerProps['isVideoView'];
    }
    interface VimeScrubberControl {
        /**
          * Whether the timestamp in the tooltip should show the hours unit, even if the time is less than 1 hour (eg: `20:35` -> `00:20:35`).
         */
        "alwaysShowHours": boolean;
        "buffered": PlayerProps['buffered'];
        "buffering": PlayerProps['buffering'];
        "currentTime": PlayerProps['currentTime'];
        "duration": PlayerProps['duration'];
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip": boolean;
        "i18n": PlayerProps['i18n'];
        /**
          * Prevents seeking forward/backward by using the Left/Right arrow keys.
         */
        "noKeyboard": boolean;
    }
    interface VimeSettings {
        /**
          * Whether the settings menu is opened/closed.
         */
        "active": boolean;
        /**
          * The height of any lower control bar in pixels so that the settings can re-position itself accordingly.
         */
        "controlsHeight": number;
        "isAudioView": PlayerProps['isAudioView'];
        "isMobile": PlayerProps['isMobile'];
        /**
          * Pins the settings to the defined position inside the video player. This has no effect when the view is of type `audio` (always `bottomRight`) and on mobile devices (always bottom sheet).
         */
        "pin": 'topLeft' | 'topRight' | 'bottomLeft' | 'bottomRight';
        /**
          * Sets the controller responsible for opening/closing this settings.
         */
        "setController": (id: string, controller: SettingsController) => Promise<void>;
    }
    interface VimeSettingsControl {
        /**
          * Whether the settings menu this control manages is open.
         */
        "expanded": boolean;
        "i18n": PlayerProps['i18n'];
        /**
          * The URL to an SVG element or fragment to load.
         */
        "icon": string;
        /**
          * The DOM `id` of the settings menu this control is responsible for opening/closing.
         */
        "menu"?: string;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection": TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition": TooltipPosition;
    }
    interface VimeSkeleton {
        /**
          * Determines which effect the skeleton will use.
         */
        "effect": 'sheen' | 'none';
        "ready": PlayerProps['ready'];
    }
    interface VimeSlider {
        /**
          * A human-readable label for the purpose of the slider.
         */
        "label"?: string;
        /**
          * The greatest permitted value.
         */
        "max": number;
        /**
          * The lowest value in the range of permitted values.
         */
        "min": number;
        /**
          * A number that specifies the granularity that the value must adhere to.
         */
        "step": number;
        /**
          * The current value.
         */
        "value": number;
        /**
          * Human-readable text alternative for the current value. Defaults to `value:max` percentage.
         */
        "valueText"?: string;
    }
    interface VimeSpinner {
        "buffering": PlayerProps['buffering'];
        "currentProvider"?: PlayerProps['currentProvider'];
        "isVideoView": PlayerProps['isVideoView'];
    }
    interface VimeSubmenu {
        /**
          * Whether the submenu is open/closed.
         */
        "active": boolean;
        /**
          * Whether the submenu should be displayed or not.
         */
        "hidden": boolean;
        /**
          * This can provide additional context about the current state of the submenu. For example, the hint could be the currently selected option if the submenu contains a radio group.
         */
        "hint"?: string;
        /**
          * The title of the submenu.
         */
        "label": string;
    }
    interface VimeTime {
        /**
          * Whether the time should always show the hours unit, even if the time is less than 1 hour (eg: `20:35` -> `00:20:35`).
         */
        "alwaysShowHours": boolean;
        /**
          * The `aria-label` property of the time.
         */
        "label": string;
        /**
          * The length of time in seconds.
         */
        "seconds": number;
    }
    interface VimeTimeProgress {
        /**
          * Whether the times should always show the hours unit, even if the time is less than 1 hour (eg: `20:35` -> `00:20:35`).
         */
        "alwaysShowHours": boolean;
        /**
          * The string used to separate the current time and end time.
         */
        "separator": string;
    }
    interface VimeTooltip {
        /**
          * Whether the tooltip is visible or not.
         */
        "active": boolean;
        /**
          * Determines if the tooltip should grow according to its contents to the left/right. By default content grows outwards from the center.
         */
        "direction"?: TooltipDirection;
        /**
          * Whether the tooltip is displayed or not.
         */
        "hidden": boolean;
        "isTouch": PlayerProps['isTouch'];
        /**
          * Determines if the tooltip appears on top/bottom of it's parent.
         */
        "position": TooltipPosition;
    }
    interface VimeUi {
        "isFullscreenActive": PlayerProps['isFullscreenActive'];
        "isVideoView": PlayerProps['isVideoView'];
        "playsinline": PlayerProps['playsinline'];
    }
    interface VimeVideo {
        /**
          * **EXPERIMENTAL:** Whether the browser should automatically toggle picture-in-picture mode as the user switches back and forth between this document and another document or application.
          * @inheritdoc
         */
        "autoPiP"?: boolean;
        /**
          * Determines what controls to show on the media element whenever the browser shows its own set of controls (e.g. when the controls attribute is specified).
          * @inheritdoc
         */
        "controlsList"?: string;
        /**
          * Whether to use CORS to fetch the related image. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/crossorigin) for more information.
          * @inheritdoc
         */
        "crossOrigin"?: MediaCrossOriginOption;
        /**
          * **EXPERIMENTAL:** Prevents the browser from suggesting a picture-in-picture context menu or to request picture-in-picture automatically in some cases.
          * @inheritdoc
         */
        "disablePiP"?: boolean;
        /**
          * **EXPERIMENTAL:** Whether to disable the capability of remote playback in devices that are attached using wired (HDMI, DVI, etc.) and wireless technologies (Miracast, Chromecast, DLNA, AirPlay, etc).
          * @inheritdoc
         */
        "disableRemotePlayback"?: boolean;
        "getAdapter": () => Promise<{ getInternalPlayer: () => Promise<HTMLMediaElement>; play: () => Promise<void | undefined>; pause: () => Promise<void | undefined>; canPlay: (type: any) => Promise<boolean>; setCurrentTime: (time: number) => Promise<void>; setMuted: (muted: boolean) => Promise<void>; setVolume: (volume: number) => Promise<void>; canSetPlaybackRate: () => Promise<boolean>; setPlaybackRate: (rate: number) => Promise<void>; canSetPlaybackQuality: () => Promise<boolean>; setPlaybackQuality: (quality: string) => Promise<void>; canSetPiP: () => Promise<boolean>; enterPiP: () => Promise<any>; exitPiP: () => Promise<any>; canSetFullscreen: () => Promise<boolean>; enterFullscreen: () => Promise<any>; exitFullscreen: () => Promise<any>; }>;
        /**
          * The title of the current media.
         */
        "mediaTitle"?: string;
        /**
          * A URL for an image to be shown while the video is downloading. If this attribute isn't specified, nothing is displayed until the first frame is available, then the first frame is shown as the poster frame.
          * @inheritdoc
         */
        "poster"?: string;
        /**
          * Provides a hint to the browser about what the author thinks will lead to the best user experience with regards to what content is loaded before the video is played. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload) for more information.
          * @inheritdoc
         */
        "preload"?: MediaPreloadOption;
        "willAttach": boolean;
    }
    interface VimeVimeo {
        "aspectRatio": string;
        "autoplay": boolean;
        /**
          * Whether to display the video owner's name.
         */
        "byline": boolean;
        /**
          * The hexadecimal color value of the playback controls. The embed settings of the video might override this value.
         */
        "color"?: string;
        "controls": boolean;
        "getAdapter": () => Promise<{ getInternalPlayer: () => Promise<HTMLVimeEmbedElement>; play: () => Promise<void>; pause: () => Promise<void>; canPlay: (type: any) => Promise<boolean>; setCurrentTime: (time: number) => Promise<void>; setMuted: (muted: boolean) => Promise<void>; setVolume: (volume: number) => Promise<void>; canSetPlaybackRate: () => Promise<boolean>; setPlaybackRate: (rate: number) => Promise<void>; }>;
        "language": string;
        "logger"?: Logger;
        "loop": boolean;
        "muted": boolean;
        /**
          * Turns off automatically determining the aspect ratio of the current video.
         */
        "noAutoAspectRatio": boolean;
        "playsinline": boolean;
        /**
          * Whether to display the video owner's portrait.
         */
        "portrait": boolean;
        /**
          * The absolute URL of a custom poster to be used for the current video.
         */
        "poster"?: string;
        /**
          * The Vimeo resource ID of the video to load.
         */
        "videoId": string;
    }
    interface VimeVolumeControl {
        /**
          * Whether the tooltip should be hidden.
         */
        "hideTooltip": boolean;
        /**
          * The URL to an SVG element or fragment.
         */
        "highVolumeIcon": string;
        "i18n": PlayerProps['i18n'];
        "isMobile": PlayerProps['isMobile'];
        /**
          * The URL to an SVG element or fragment.
         */
        "lowVolumeIcon": string;
        /**
          * A pipe (`/`) separated string of JS keyboard keys, that when caught in a `keydown` event, will toggle the muted state of the player.
         */
        "muteKeys"?: string;
        "muted": PlayerProps['muted'];
        /**
          * The URL to an SVG element or fragment.
         */
        "mutedIcon": string;
        /**
          * Prevents the volume being changed using the Up/Down arrow keys.
         */
        "noKeyboard": boolean;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection": TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition": TooltipPosition;
        "volume": PlayerProps['volume'];
    }
    interface VimeYoutube {
        "autoplay": boolean;
        "controls": boolean;
        /**
          * Whether cookies should be enabled on the embed.
         */
        "cookies": boolean;
        "getAdapter": () => Promise<{ getInternalPlayer: () => Promise<HTMLVimeEmbedElement>; play: () => Promise<void>; pause: () => Promise<void>; canPlay: (type: any) => Promise<boolean>; setCurrentTime: (time: number) => Promise<void>; setMuted: (muted: boolean) => Promise<void>; setVolume: (volume: number) => Promise<void>; canSetPlaybackRate: () => Promise<boolean>; setPlaybackRate: (rate: number) => Promise<void>; }>;
        "language": string;
        "logger"?: Logger;
        "loop": boolean;
        "muted": boolean;
        "playsinline": boolean;
        /**
          * The absolute URL of a custom poster to be used for the current video.
         */
        "poster"?: string;
        /**
          * Whether the fullscreen control should be shown.
         */
        "showFullscreenControl": boolean;
        /**
          * The YouTube resource ID of the video to load.
         */
        "videoId": string;
    }
}
declare global {
    interface HTMLVimeAudioElement extends Components.VimeAudio, HTMLStencilElement {
    }
    var HTMLVimeAudioElement: {
        prototype: HTMLVimeAudioElement;
        new (): HTMLVimeAudioElement;
    };
    interface HTMLVimeCaptionControlElement extends Components.VimeCaptionControl, HTMLStencilElement {
    }
    var HTMLVimeCaptionControlElement: {
        prototype: HTMLVimeCaptionControlElement;
        new (): HTMLVimeCaptionControlElement;
    };
    interface HTMLVimeCaptionsElement extends Components.VimeCaptions, HTMLStencilElement {
    }
    var HTMLVimeCaptionsElement: {
        prototype: HTMLVimeCaptionsElement;
        new (): HTMLVimeCaptionsElement;
    };
    interface HTMLVimeClickToPlayElement extends Components.VimeClickToPlay, HTMLStencilElement {
    }
    var HTMLVimeClickToPlayElement: {
        prototype: HTMLVimeClickToPlayElement;
        new (): HTMLVimeClickToPlayElement;
    };
    interface HTMLVimeControlElement extends Components.VimeControl, HTMLStencilElement {
    }
    var HTMLVimeControlElement: {
        prototype: HTMLVimeControlElement;
        new (): HTMLVimeControlElement;
    };
    interface HTMLVimeControlGroupElement extends Components.VimeControlGroup, HTMLStencilElement {
    }
    var HTMLVimeControlGroupElement: {
        prototype: HTMLVimeControlGroupElement;
        new (): HTMLVimeControlGroupElement;
    };
    interface HTMLVimeControlSpacerElement extends Components.VimeControlSpacer, HTMLStencilElement {
    }
    var HTMLVimeControlSpacerElement: {
        prototype: HTMLVimeControlSpacerElement;
        new (): HTMLVimeControlSpacerElement;
    };
    interface HTMLVimeControlsElement extends Components.VimeControls, HTMLStencilElement {
    }
    var HTMLVimeControlsElement: {
        prototype: HTMLVimeControlsElement;
        new (): HTMLVimeControlsElement;
    };
    interface HTMLVimeCurrentTimeElement extends Components.VimeCurrentTime, HTMLStencilElement {
    }
    var HTMLVimeCurrentTimeElement: {
        prototype: HTMLVimeCurrentTimeElement;
        new (): HTMLVimeCurrentTimeElement;
    };
    interface HTMLVimeDailymotionElement extends Components.VimeDailymotion, HTMLStencilElement {
    }
    var HTMLVimeDailymotionElement: {
        prototype: HTMLVimeDailymotionElement;
        new (): HTMLVimeDailymotionElement;
    };
    interface HTMLVimeDashElement extends Components.VimeDash, HTMLStencilElement {
    }
    var HTMLVimeDashElement: {
        prototype: HTMLVimeDashElement;
        new (): HTMLVimeDashElement;
    };
    interface HTMLVimeDblClickFullscreenElement extends Components.VimeDblClickFullscreen, HTMLStencilElement {
    }
    var HTMLVimeDblClickFullscreenElement: {
        prototype: HTMLVimeDblClickFullscreenElement;
        new (): HTMLVimeDblClickFullscreenElement;
    };
    interface HTMLVimeDefaultControlsElement extends Components.VimeDefaultControls, HTMLStencilElement {
    }
    var HTMLVimeDefaultControlsElement: {
        prototype: HTMLVimeDefaultControlsElement;
        new (): HTMLVimeDefaultControlsElement;
    };
    interface HTMLVimeDefaultSettingsElement extends Components.VimeDefaultSettings, HTMLStencilElement {
    }
    var HTMLVimeDefaultSettingsElement: {
        prototype: HTMLVimeDefaultSettingsElement;
        new (): HTMLVimeDefaultSettingsElement;
    };
    interface HTMLVimeDefaultUiElement extends Components.VimeDefaultUi, HTMLStencilElement {
    }
    var HTMLVimeDefaultUiElement: {
        prototype: HTMLVimeDefaultUiElement;
        new (): HTMLVimeDefaultUiElement;
    };
    interface HTMLVimeEmbedElement extends Components.VimeEmbed, HTMLStencilElement {
    }
    var HTMLVimeEmbedElement: {
        prototype: HTMLVimeEmbedElement;
        new (): HTMLVimeEmbedElement;
    };
    interface HTMLVimeEndTimeElement extends Components.VimeEndTime, HTMLStencilElement {
    }
    var HTMLVimeEndTimeElement: {
        prototype: HTMLVimeEndTimeElement;
        new (): HTMLVimeEndTimeElement;
    };
    interface HTMLVimeFaketubeElement extends Components.VimeFaketube, HTMLStencilElement {
    }
    var HTMLVimeFaketubeElement: {
        prototype: HTMLVimeFaketubeElement;
        new (): HTMLVimeFaketubeElement;
    };
    interface HTMLVimeFileElement extends Components.VimeFile, HTMLStencilElement {
    }
    var HTMLVimeFileElement: {
        prototype: HTMLVimeFileElement;
        new (): HTMLVimeFileElement;
    };
    interface HTMLVimeFullscreenControlElement extends Components.VimeFullscreenControl, HTMLStencilElement {
    }
    var HTMLVimeFullscreenControlElement: {
        prototype: HTMLVimeFullscreenControlElement;
        new (): HTMLVimeFullscreenControlElement;
    };
    interface HTMLVimeHlsElement extends Components.VimeHls, HTMLStencilElement {
    }
    var HTMLVimeHlsElement: {
        prototype: HTMLVimeHlsElement;
        new (): HTMLVimeHlsElement;
    };
    interface HTMLVimeIconElement extends Components.VimeIcon, HTMLStencilElement {
    }
    var HTMLVimeIconElement: {
        prototype: HTMLVimeIconElement;
        new (): HTMLVimeIconElement;
    };
    interface HTMLVimeIconsElement extends Components.VimeIcons, HTMLStencilElement {
    }
    var HTMLVimeIconsElement: {
        prototype: HTMLVimeIconsElement;
        new (): HTMLVimeIconsElement;
    };
    interface HTMLVimeLiveIndicatorElement extends Components.VimeLiveIndicator, HTMLStencilElement {
    }
    var HTMLVimeLiveIndicatorElement: {
        prototype: HTMLVimeLiveIndicatorElement;
        new (): HTMLVimeLiveIndicatorElement;
    };
    interface HTMLVimeMenuElement extends Components.VimeMenu, HTMLStencilElement {
    }
    var HTMLVimeMenuElement: {
        prototype: HTMLVimeMenuElement;
        new (): HTMLVimeMenuElement;
    };
    interface HTMLVimeMenuItemElement extends Components.VimeMenuItem, HTMLStencilElement {
    }
    var HTMLVimeMenuItemElement: {
        prototype: HTMLVimeMenuItemElement;
        new (): HTMLVimeMenuItemElement;
    };
    interface HTMLVimeMenuRadioElement extends Components.VimeMenuRadio, HTMLStencilElement {
    }
    var HTMLVimeMenuRadioElement: {
        prototype: HTMLVimeMenuRadioElement;
        new (): HTMLVimeMenuRadioElement;
    };
    interface HTMLVimeMenuRadioGroupElement extends Components.VimeMenuRadioGroup, HTMLStencilElement {
    }
    var HTMLVimeMenuRadioGroupElement: {
        prototype: HTMLVimeMenuRadioGroupElement;
        new (): HTMLVimeMenuRadioGroupElement;
    };
    interface HTMLVimeMuteControlElement extends Components.VimeMuteControl, HTMLStencilElement {
    }
    var HTMLVimeMuteControlElement: {
        prototype: HTMLVimeMuteControlElement;
        new (): HTMLVimeMuteControlElement;
    };
    interface HTMLVimePipControlElement extends Components.VimePipControl, HTMLStencilElement {
    }
    var HTMLVimePipControlElement: {
        prototype: HTMLVimePipControlElement;
        new (): HTMLVimePipControlElement;
    };
    interface HTMLVimePlaybackControlElement extends Components.VimePlaybackControl, HTMLStencilElement {
    }
    var HTMLVimePlaybackControlElement: {
        prototype: HTMLVimePlaybackControlElement;
        new (): HTMLVimePlaybackControlElement;
    };
    interface HTMLVimePlayerElement extends Components.VimePlayer, HTMLStencilElement {
    }
    var HTMLVimePlayerElement: {
        prototype: HTMLVimePlayerElement;
        new (): HTMLVimePlayerElement;
    };
    interface HTMLVimePlaygroundElement extends Components.VimePlayground, HTMLStencilElement {
    }
    var HTMLVimePlaygroundElement: {
        prototype: HTMLVimePlaygroundElement;
        new (): HTMLVimePlaygroundElement;
    };
    interface HTMLVimePosterElement extends Components.VimePoster, HTMLStencilElement {
    }
    var HTMLVimePosterElement: {
        prototype: HTMLVimePosterElement;
        new (): HTMLVimePosterElement;
    };
    interface HTMLVimeScrimElement extends Components.VimeScrim, HTMLStencilElement {
    }
    var HTMLVimeScrimElement: {
        prototype: HTMLVimeScrimElement;
        new (): HTMLVimeScrimElement;
    };
    interface HTMLVimeScrubberControlElement extends Components.VimeScrubberControl, HTMLStencilElement {
    }
    var HTMLVimeScrubberControlElement: {
        prototype: HTMLVimeScrubberControlElement;
        new (): HTMLVimeScrubberControlElement;
    };
    interface HTMLVimeSettingsElement extends Components.VimeSettings, HTMLStencilElement {
    }
    var HTMLVimeSettingsElement: {
        prototype: HTMLVimeSettingsElement;
        new (): HTMLVimeSettingsElement;
    };
    interface HTMLVimeSettingsControlElement extends Components.VimeSettingsControl, HTMLStencilElement {
    }
    var HTMLVimeSettingsControlElement: {
        prototype: HTMLVimeSettingsControlElement;
        new (): HTMLVimeSettingsControlElement;
    };
    interface HTMLVimeSkeletonElement extends Components.VimeSkeleton, HTMLStencilElement {
    }
    var HTMLVimeSkeletonElement: {
        prototype: HTMLVimeSkeletonElement;
        new (): HTMLVimeSkeletonElement;
    };
    interface HTMLVimeSliderElement extends Components.VimeSlider, HTMLStencilElement {
    }
    var HTMLVimeSliderElement: {
        prototype: HTMLVimeSliderElement;
        new (): HTMLVimeSliderElement;
    };
    interface HTMLVimeSpinnerElement extends Components.VimeSpinner, HTMLStencilElement {
    }
    var HTMLVimeSpinnerElement: {
        prototype: HTMLVimeSpinnerElement;
        new (): HTMLVimeSpinnerElement;
    };
    interface HTMLVimeSubmenuElement extends Components.VimeSubmenu, HTMLStencilElement {
    }
    var HTMLVimeSubmenuElement: {
        prototype: HTMLVimeSubmenuElement;
        new (): HTMLVimeSubmenuElement;
    };
    interface HTMLVimeTimeElement extends Components.VimeTime, HTMLStencilElement {
    }
    var HTMLVimeTimeElement: {
        prototype: HTMLVimeTimeElement;
        new (): HTMLVimeTimeElement;
    };
    interface HTMLVimeTimeProgressElement extends Components.VimeTimeProgress, HTMLStencilElement {
    }
    var HTMLVimeTimeProgressElement: {
        prototype: HTMLVimeTimeProgressElement;
        new (): HTMLVimeTimeProgressElement;
    };
    interface HTMLVimeTooltipElement extends Components.VimeTooltip, HTMLStencilElement {
    }
    var HTMLVimeTooltipElement: {
        prototype: HTMLVimeTooltipElement;
        new (): HTMLVimeTooltipElement;
    };
    interface HTMLVimeUiElement extends Components.VimeUi, HTMLStencilElement {
    }
    var HTMLVimeUiElement: {
        prototype: HTMLVimeUiElement;
        new (): HTMLVimeUiElement;
    };
    interface HTMLVimeVideoElement extends Components.VimeVideo, HTMLStencilElement {
    }
    var HTMLVimeVideoElement: {
        prototype: HTMLVimeVideoElement;
        new (): HTMLVimeVideoElement;
    };
    interface HTMLVimeVimeoElement extends Components.VimeVimeo, HTMLStencilElement {
    }
    var HTMLVimeVimeoElement: {
        prototype: HTMLVimeVimeoElement;
        new (): HTMLVimeVimeoElement;
    };
    interface HTMLVimeVolumeControlElement extends Components.VimeVolumeControl, HTMLStencilElement {
    }
    var HTMLVimeVolumeControlElement: {
        prototype: HTMLVimeVolumeControlElement;
        new (): HTMLVimeVolumeControlElement;
    };
    interface HTMLVimeYoutubeElement extends Components.VimeYoutube, HTMLStencilElement {
    }
    var HTMLVimeYoutubeElement: {
        prototype: HTMLVimeYoutubeElement;
        new (): HTMLVimeYoutubeElement;
    };
    interface HTMLElementTagNameMap {
        "vime-audio": HTMLVimeAudioElement;
        "vime-caption-control": HTMLVimeCaptionControlElement;
        "vime-captions": HTMLVimeCaptionsElement;
        "vime-click-to-play": HTMLVimeClickToPlayElement;
        "vime-control": HTMLVimeControlElement;
        "vime-control-group": HTMLVimeControlGroupElement;
        "vime-control-spacer": HTMLVimeControlSpacerElement;
        "vime-controls": HTMLVimeControlsElement;
        "vime-current-time": HTMLVimeCurrentTimeElement;
        "vime-dailymotion": HTMLVimeDailymotionElement;
        "vime-dash": HTMLVimeDashElement;
        "vime-dbl-click-fullscreen": HTMLVimeDblClickFullscreenElement;
        "vime-default-controls": HTMLVimeDefaultControlsElement;
        "vime-default-settings": HTMLVimeDefaultSettingsElement;
        "vime-default-ui": HTMLVimeDefaultUiElement;
        "vime-embed": HTMLVimeEmbedElement;
        "vime-end-time": HTMLVimeEndTimeElement;
        "vime-faketube": HTMLVimeFaketubeElement;
        "vime-file": HTMLVimeFileElement;
        "vime-fullscreen-control": HTMLVimeFullscreenControlElement;
        "vime-hls": HTMLVimeHlsElement;
        "vime-icon": HTMLVimeIconElement;
        "vime-icons": HTMLVimeIconsElement;
        "vime-live-indicator": HTMLVimeLiveIndicatorElement;
        "vime-menu": HTMLVimeMenuElement;
        "vime-menu-item": HTMLVimeMenuItemElement;
        "vime-menu-radio": HTMLVimeMenuRadioElement;
        "vime-menu-radio-group": HTMLVimeMenuRadioGroupElement;
        "vime-mute-control": HTMLVimeMuteControlElement;
        "vime-pip-control": HTMLVimePipControlElement;
        "vime-playback-control": HTMLVimePlaybackControlElement;
        "vime-player": HTMLVimePlayerElement;
        "vime-playground": HTMLVimePlaygroundElement;
        "vime-poster": HTMLVimePosterElement;
        "vime-scrim": HTMLVimeScrimElement;
        "vime-scrubber-control": HTMLVimeScrubberControlElement;
        "vime-settings": HTMLVimeSettingsElement;
        "vime-settings-control": HTMLVimeSettingsControlElement;
        "vime-skeleton": HTMLVimeSkeletonElement;
        "vime-slider": HTMLVimeSliderElement;
        "vime-spinner": HTMLVimeSpinnerElement;
        "vime-submenu": HTMLVimeSubmenuElement;
        "vime-time": HTMLVimeTimeElement;
        "vime-time-progress": HTMLVimeTimeProgressElement;
        "vime-tooltip": HTMLVimeTooltipElement;
        "vime-ui": HTMLVimeUiElement;
        "vime-video": HTMLVimeVideoElement;
        "vime-vimeo": HTMLVimeVimeoElement;
        "vime-volume-control": HTMLVimeVolumeControlElement;
        "vime-youtube": HTMLVimeYoutubeElement;
    }
}
declare namespace LocalJSX {
    interface VimeAudio {
        /**
          * Whether to use CORS to fetch the related image. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/crossorigin) for more information.
          * @inheritdoc
         */
        "crossOrigin"?: MediaCrossOriginOption;
        /**
          * **EXPERIMENTAL:** Whether to disable the capability of remote playback in devices that are attached using wired (HDMI, DVI, etc.) and wireless technologies (Miracast, Chromecast, DLNA, AirPlay, etc).
          * @inheritdoc
         */
        "disableRemotePlayback"?: boolean;
        /**
          * The title of the current media.
         */
        "mediaTitle"?: string;
        /**
          * Provides a hint to the browser about what the author thinks will lead to the best user experience with regards to what content is loaded before the video is played. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload) for more information.
          * @inheritdoc
         */
        "preload"?: MediaPreloadOption;
    }
    interface VimeCaptionControl {
        /**
          * The URL to an SVG element or fragment to load.
         */
        "hideIcon"?: string;
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip"?: boolean;
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        /**
          * The URL to an SVG element or fragment to load.
         */
        "showIcon"?: string;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection"?: TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition"?: TooltipPosition;
    }
    interface VimeCaptions {
        /**
          * The height of any lower control bar in pixels so that the captions can reposition when it's active.
         */
        "controlsHeight"?: number;
        /**
          * Whether the captions should be visible or not.
         */
        "hidden"?: boolean;
        /**
          * Emitted when the active cues change. A cue is active when `currentTime >= cue.startTime && currentTime <= cue.endTime`.
         */
        "onVCuesChange"?: (event: CustomEvent<TextTrackCue[]>) => void;
        /**
          * Emitted when the current track changes.
         */
        "onVTrackChange"?: (event: CustomEvent<TextTrack | undefined>) => void;
    }
    interface VimeClickToPlay {
        /**
          * By default this is disabled on mobile to not interfere with playback, set this to `true` to enable it.
         */
        "useOnMobile"?: boolean;
    }
    interface VimeControl {
        /**
          * If the control has a popup menu, this indicates whether the menu is open or not. Sets the `aria-expanded` property.
         */
        "expanded"?: boolean;
        /**
          * Whether the control should be displayed or not.
         */
        "hidden"?: boolean;
        /**
          * The `id` attribute of the control.
         */
        "identifier"?: string;
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        /**
          * The `aria-label` property of the control.
         */
        "label": string;
        /**
          * If the control has a popup menu, then this should be the `id` of said menu. Sets the `aria-controls` property.
         */
        "menu"?: string;
        /**
          * Emitted when the user is interacting with the control by focusing, touching or hovering on it.
         */
        "onVInteractionChange"?: (event: CustomEvent<boolean>) => void;
        /**
          * If the control is a toggle, this indicated whether the control is in a "pressed" state or not. Sets the `aria-pressed` property.
         */
        "pressed"?: boolean;
    }
    interface VimeControlGroup {
        /**
          * Determines where to add spacing/margin. The amount of spacing is determined by the CSS variable `--control-group-spacing`.
         */
        "space"?: 'top' | 'bottom' | 'both' | 'none';
    }
    interface VimeControlSpacer {
    }
    interface VimeControls {
        /**
          * The length in milliseconds that the controls are active for before fading out. Audio players are not effected by this prop.
         */
        "activeDuration"?: number;
        /**
          * Sets the `align-items` flex property that aligns the individual controls on the cross-axis.
         */
        "align"?: 'start' | 'center' | 'end';
        /**
          * Sets the `flex-direction` property that manages the direction in which the controls are layed out.
         */
        "direction"?: 'row' | 'column';
        /**
          * Whether the controls container should be 100% height. This has no effect if the view is of type `audio`.
         */
        "fullHeight"?: boolean;
        /**
          * Whether the controls container should be 100% width. This has no effect if the view is of type `audio`.
         */
        "fullWidth"?: boolean;
        /**
          * Whether the controls are visible or not.
         */
        "hidden"?: boolean;
        /**
          * Whether the controls should hide when the mouse leaves the player. Audio players are not effected by this prop.
         */
        "hideOnMouseLeave"?: boolean;
        /**
          * Whether the controls should show/hide when paused. Audio players are not effected by this prop.
         */
        "hideWhenPaused"?: boolean;
        /**
          * Sets the `justify-content` flex property that aligns the individual controls on the main-axis.
         */
        "justify"?: 'start'
  | 'center'
  | 'end'
  | 'space-around'
  | 'space-between'
  | 'space-evenly';
        /**
          * Pins the controls to the defined position inside the video player. This has no effect when the view is of type `audio`.
         */
        "pin"?: 'topLeft' | 'topRight' | 'bottomLeft' | 'bottomRight' | 'center';
        /**
          * Whether the controls should wait for playback to start before being shown. Audio players are not effected by this prop.
         */
        "waitForPlaybackStart"?: boolean;
    }
    interface VimeCurrentTime {
        /**
          * Whether the time should always show the hours unit, even if the time is less than 1 hour (eg: `20:35` -> `00:20:35`).
         */
        "alwaysShowHours"?: boolean;
    }
    interface VimeDailymotion {
        /**
          * Change the default highlight color used in the controls (hex value without the leading #). Color set in the Partner HQ will override this prop.
         */
        "color"?: string;
        /**
          * The absolute URL of a custom poster to be used for the current video.
         */
        "poster"?: string;
        /**
          * Whether to automatically play the next video in the queue.
         */
        "shouldAutoplayQueue"?: boolean;
        /**
          * Whether to display the Dailymotion logo.
         */
        "showDailymotionLogo"?: boolean;
        /**
          * Whether to show buttons for sharing the video.
         */
        "showShareButtons"?: boolean;
        /**
          * Whether to show the 'Up Next' queue.
         */
        "showUpNextQueue"?: boolean;
        /**
          * Whether to show video information (title and owner) on the start screen.
         */
        "showVideoInfo"?: boolean;
        /**
          * Forwards your syndication key to the player.
         */
        "syndication"?: string;
        /**
          * The Dailymotion resource ID of the video to load.
         */
        "videoId": string;
    }
    interface VimeDash {
        /**
          * **EXPERIMENTAL:** Whether the browser should automatically toggle picture-in-picture mode as the user switches back and forth between this document and another document or application.
          * @inheritdoc
         */
        "autoPiP"?: boolean;
        /**
          * The `dashjs` configuration.
         */
        "config"?: Record<string, any>;
        /**
          * Determines what controls to show on the media element whenever the browser shows its own set of controls (e.g. when the controls attribute is specified).
          * @inheritdoc
         */
        "controlsList"?: string;
        /**
          * Whether to use CORS to fetch the related image. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/crossorigin) for more information.
          * @inheritdoc
         */
        "crossOrigin"?: MediaCrossOriginOption;
        /**
          * **EXPERIMENTAL:** Prevents the browser from suggesting a picture-in-picture context menu or to request picture-in-picture automatically in some cases.
          * @inheritdoc
         */
        "disablePiP"?: boolean;
        /**
          * **EXPERIMENTAL:** Whether to disable the capability of remote playback in devices that are attached using wired (HDMI, DVI, etc.) and wireless technologies (Miracast, Chromecast, DLNA, AirPlay, etc).
          * @inheritdoc
         */
        "disableRemotePlayback"?: boolean;
        /**
          * The title of the current media.
         */
        "mediaTitle"?: string;
        /**
          * A URL for an image to be shown while the video is downloading. If this attribute isn't specified, nothing is displayed until the first frame is available, then the first frame is shown as the poster frame.
          * @inheritdoc
         */
        "poster"?: string;
        /**
          * Provides a hint to the browser about what the author thinks will lead to the best user experience with regards to what content is loaded before the video is played. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload) for more information.
          * @inheritdoc
         */
        "preload"?: MediaPreloadOption;
        /**
          * The URL of the `manifest.mpd` file to use.
         */
        "src": string;
        /**
          * The NPM package version of the `dashjs` library to download and use.
         */
        "version"?: string;
    }
    interface VimeDblClickFullscreen {
        /**
          * By default this is disabled on mobile to not interfere with playback, set this to `true` to enable it.
         */
        "useOnMobile"?: boolean;
    }
    interface VimeDefaultControls {
        /**
          * The length in milliseconds that the controls are active for before fading out. Audio players are not effected by this prop.
         */
        "activeDuration"?: number;
        /**
          * Whether the controls should hide when the mouse leaves the player. Audio players are not effected by this prop.
         */
        "hideOnMouseLeave"?: boolean;
        /**
          * Whether the controls should show/hide when paused. Audio players are not effected by this prop.
         */
        "hideWhenPaused"?: boolean;
        /**
          * Whether the controls should wait for playback to start before being shown. Audio players are not effected by this prop.
         */
        "waitForPlaybackStart"?: boolean;
    }
    interface VimeDefaultSettings {
        /**
          * Pins the settings to the defined position inside the video player. This has no effect when the view is of type `audio`, it will always be `bottomRight`.
         */
        "pin"?: 'topLeft' | 'topRight' | 'bottomLeft' | 'bottomRight';
    }
    interface VimeDefaultUi {
        /**
          * Whether the custom captions UI should not be loaded.
         */
        "noCaptions"?: boolean;
        /**
          * Whether clicking the player should not toggle playback.
         */
        "noClickToPlay"?: boolean;
        /**
          * Whether the custom default controls should not be loaded.
         */
        "noControls"?: boolean;
        /**
          * Whether double clicking the player should not toggle fullscreen mode.
         */
        "noDblClickFullscreen"?: boolean;
        /**
          * Whether the default icons should not be loaded.
         */
        "noIcons"?: boolean;
        /**
          * Whether the custom poster UI should not be loaded.
         */
        "noPoster"?: boolean;
        /**
          * Whether the custom default settings menu should not be loaded.
         */
        "noSettings"?: boolean;
        /**
          * Whether the skeleton loading animation should be shown while the player is loading.
         */
        "noSkeleton"?: boolean;
        /**
          * Whether the custom spinner UI should not be loaded.
         */
        "noSpinner"?: boolean;
    }
    interface VimeEmbed {
        /**
          * A function which accepts the raw message received from the embedded media player via `postMessage` and converts it into a POJO.
         */
        "decoder"?: (data: string) => Params | undefined;
        /**
          * A URL that will load the external player and media (Eg: https://www.youtube.com/embed/DyTCOwB0DVw).
         */
        "embedSrc"?: string;
        /**
          * The title of the current media so it can be set on the inner `iframe` for screen readers.
         */
        "mediaTitle"?: string;
        /**
          * Emitted when the embedded player and any new media has loaded.
         */
        "onVEmbedLoaded"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when a new message is received from the embedded player via `postMessage`.
         */
        "onVEmbedMessage"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the `embedSrc` or `params` props change. The payload contains the `params` serialized into a query string and appended to `embedSrc`.
         */
        "onVEmbedSrcChange"?: (event: CustomEvent<string>) => void;
        /**
          * Where the src request had originated from without any path information.
         */
        "origin"?: string;
        /**
          * The parameters to pass to the embedded player which are appended to the `embedSrc` prop. These can be passed in as a query string or object.
         */
        "params"?: string | Params;
        /**
          * A collection of URLs to that the browser should immediately start establishing a connection with.
         */
        "preconnections"?: string[];
    }
    interface VimeEndTime {
        /**
          * Whether the time should always show the hours unit, even if the time is less than 1 hour (eg: `20:35` -> `00:20:35`).
         */
        "alwaysShowHours"?: boolean;
    }
    interface VimeFaketube {
    }
    interface VimeFile {
        /**
          * **EXPERIMENTAL:** Whether the browser should automatically toggle picture-in-picture mode as the user switches back and forth between this document and another document or application.
          * @inheritdoc
         */
        "autoPiP"?: boolean;
        /**
          * Determines what controls to show on the media element whenever the browser shows its own set of controls (e.g. when the controls attribute is specified).
          * @inheritdoc
         */
        "controlsList"?: string;
        /**
          * Whether to use CORS to fetch the related image. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/crossorigin) for more information.
          * @inheritdoc
         */
        "crossOrigin"?: MediaCrossOriginOption;
        /**
          * **EXPERIMENTAL:** Prevents the browser from suggesting a picture-in-picture context menu or to request picture-in-picture automatically in some cases.
          * @inheritdoc
         */
        "disablePiP"?: boolean;
        /**
          * **EXPERIMENTAL:** Whether to disable the capability of remote playback in devices that are attached using wired (HDMI, DVI, etc.) and wireless technologies (Miracast, Chromecast, DLNA, AirPlay, etc).
          * @inheritdoc
         */
        "disableRemotePlayback"?: boolean;
        /**
          * The title of the current media.
         */
        "mediaTitle"?: string;
        /**
          * Emitted when the underlying media element changes.
         */
        "onVMediaElChange"?: (event: CustomEvent<HTMLAudioElement | HTMLVideoElement | undefined>) => void;
        /**
          * Emitted when the child `<source />` elements are modified.
         */
        "onVSrcSetChange"?: (event: CustomEvent<MediaResource[]>) => void;
        /**
          * The playback rates that are available for this media.
         */
        "playbackRates"?: number[];
        /**
          * A URL for an image to be shown while the video is downloading. If this attribute isn't specified, nothing is displayed until the first frame is available, then the first frame is shown as the poster frame.
          * @inheritdoc
         */
        "poster"?: string;
        /**
          * Provides a hint to the browser about what the author thinks will lead to the best user experience with regards to what content is loaded before the video is played. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload) for more information.
          * @inheritdoc
         */
        "preload"?: MediaPreloadOption;
        /**
          * Whether to use an `audio` or `video` element to play the media.
         */
        "viewType"?: ViewType;
    }
    interface VimeFullscreenControl {
        /**
          * The URL to an SVG element or fragment to display for entering fullscreen.
         */
        "enterIcon"?: string;
        /**
          * The URL to an SVG element or fragment to display for exiting fullscreen.
         */
        "exitIcon"?: string;
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip"?: boolean;
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection"?: TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition"?: TooltipPosition;
    }
    interface VimeHls {
        /**
          * **EXPERIMENTAL:** Whether the browser should automatically toggle picture-in-picture mode as the user switches back and forth between this document and another document or application.
          * @inheritdoc
         */
        "autoPiP"?: boolean;
        /**
          * The `hls.js` configuration.
         */
        "config"?: any;
        /**
          * Determines what controls to show on the media element whenever the browser shows its own set of controls (e.g. when the controls attribute is specified).
          * @inheritdoc
         */
        "controlsList"?: string;
        /**
          * Whether to use CORS to fetch the related image. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/crossorigin) for more information.
          * @inheritdoc
         */
        "crossOrigin"?: MediaCrossOriginOption;
        /**
          * **EXPERIMENTAL:** Prevents the browser from suggesting a picture-in-picture context menu or to request picture-in-picture automatically in some cases.
          * @inheritdoc
         */
        "disablePiP"?: boolean;
        /**
          * **EXPERIMENTAL:** Whether to disable the capability of remote playback in devices that are attached using wired (HDMI, DVI, etc.) and wireless technologies (Miracast, Chromecast, DLNA, AirPlay, etc).
          * @inheritdoc
         */
        "disableRemotePlayback"?: boolean;
        /**
          * The title of the current media.
         */
        "mediaTitle"?: string;
        /**
          * A URL for an image to be shown while the video is downloading. If this attribute isn't specified, nothing is displayed until the first frame is available, then the first frame is shown as the poster frame.
          * @inheritdoc
         */
        "poster"?: string;
        /**
          * Provides a hint to the browser about what the author thinks will lead to the best user experience with regards to what content is loaded before the video is played. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload) for more information.
          * @inheritdoc
         */
        "preload"?: MediaPreloadOption;
        /**
          * The NPM package version of the `hls.js` library to download and use if HLS is not natively supported.
         */
        "version"?: string;
    }
    interface VimeIcon {
        /**
          * The URL to an SVG element or fragment to load.
         */
        "href"?: string;
    }
    interface VimeIcons {
        /**
          * The URL to an SVG sprite to load.
         */
        "href"?: string;
    }
    interface VimeLiveIndicator {
    }
    interface VimeMenu {
        /**
          * Whether the menu is open/visible.
         */
        "active"?: boolean;
        /**
          * The `id` attribute value of the control responsible for opening/closing this menu.
         */
        "controller": string;
        /**
          * The `id` attribute of the menu.
         */
        "identifier": string;
        /**
          * Emitted when the menu has closed/is not active.
         */
        "onVClose"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when the currently focused menu item changes.
         */
        "onVFocusMenuItemChange"?: (event: CustomEvent<HTMLVimeMenuItemElement | undefined>) => void;
        /**
          * Emitted when the menu items present changes.
         */
        "onVMenuItemsChange"?: (event: CustomEvent<NodeListOf<HTMLVimeMenuItemElement> | undefined>) => void;
        /**
          * Emitted when the menu is open/active.
         */
        "onVOpen"?: (event: CustomEvent<void>) => void;
    }
    interface VimeMenuItem {
        /**
          * This can provide additional context about the value of a menu item. For example, if the item is a radio button for a set of video qualities, the badge could describe whether the quality is UHD, HD etc.
         */
        "badge"?: string;
        /**
          * If this item is to behave as a radio button, then this property determines whether the radio is selected or not. Sets the `aria-checked` property.
         */
        "checked"?: boolean;
        /**
          * The URL to an SVG element or fragment to load.
         */
        "checkedIcon"?: string;
        /**
          * If the item has a popup menu, this indicates whether the menu is open or not. Sets the `aria-expanded` property.
         */
        "expanded"?: boolean;
        /**
          * Whether the item is displayed or not.
         */
        "hidden"?: boolean;
        /**
          * This can provide additional context about some underlying state of the item. For example, if the menu item opens/closes a submenu with options, the hint could be the currently selected option.
         */
        "hint"?: string;
        /**
          * The `id` attribute of the item.
         */
        "identifier"?: string;
        /**
          * The label/title of the item.
         */
        "label": string;
        /**
          * If the item has a popup menu, then this should be the `id` of said menu. Sets the `aria-controls` property.
         */
        "menu"?: string;
    }
    interface VimeMenuRadio {
        /**
          * This can provide additional context about the value. For example, if the option is for a set of video qualities, the badge could describe whether the quality is UHD, HD etc.
         */
        "badge"?: string;
        /**
          * Whether the radio item is selected or not.
         */
        "checked"?: boolean;
        /**
          * The URL to an SVG element or fragment to load.
         */
        "checkedIcon"?: string;
        /**
          * The title of the radio item displayed to the user.
         */
        "label": string;
        /**
          * Emitted when the radio button is selected.
         */
        "onVCheck"?: (event: CustomEvent<void>) => void;
        /**
          * The value associated with this radio item.
         */
        "value": string;
    }
    interface VimeMenuRadioGroup {
        /**
          * Emitted when a new radio button is selected for this group.
         */
        "onVCheck"?: (event: CustomEvent<void>) => void;
        /**
          * The current value selected for this group.
         */
        "value"?: string;
    }
    interface VimeMuteControl {
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip"?: boolean;
        /**
          * The URL to an SVG element or fragment.
         */
        "highVolumeIcon"?: string;
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        /**
          * The URL to an SVG element or fragment.
         */
        "lowVolumeIcon"?: string;
        /**
          * The URL to an SVG element or fragment.
         */
        "mutedIcon"?: string;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection"?: TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition"?: TooltipPosition;
    }
    interface VimePipControl {
        /**
          * The URL to an SVG element or fragment to display for entering PiP.
         */
        "enterIcon"?: string;
        /**
          * The URL to an SVG element or fragment to display for exiting PiP.
         */
        "exitIcon"?: string;
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip"?: boolean;
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection"?: TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition"?: TooltipPosition;
    }
    interface VimePlaybackControl {
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip"?: boolean;
        /**
          * A slash (`/`) separated string of JS keyboard keys (`KeyboardEvent.key`), that when caught in a `keydown` event, will trigger a `click` event on the control.
          * @inheritdoc
         */
        "keys"?: string;
        /**
          * The URL to an SVG element or fragment to load.
         */
        "pauseIcon"?: string;
        /**
          * The URL to an SVG element or fragment to load.
         */
        "playIcon"?: string;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection"?: TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition"?: TooltipPosition;
    }
    interface VimePlayer {
        /**
          * The aspect ratio of the player expressed as `width:height` (`16:9`). This is only applied if the `viewType` is `video` and the player is not in fullscreen mode.
          * @inheritDoc
         */
        "aspectRatio"?: string;
        /**
          * `@readonly` Whether the player is attached to the DOM.
          * @inheritDoc
         */
        "attached"?: boolean;
        /**
          * Whether the player should automatically pause when another Vime player starts/resumes playback.
          * @inheritDoc
         */
        "autopause"?: boolean;
        /**
          * Whether playback should automatically begin playing once the media is ready to do so. This will only work if the browsers `autoplay` policies have been satisfied. It'll generally work if the player is muted, or the user frequently interacts with your site. You can check if it's possible to autoplay via the `canAutoplay()` or `canMutedAutoplay()` methods. Depending on the provider, changing this prop may cause the player to completely reset.
          * @inheritDoc
         */
        "autoplay"?: boolean;
        /**
          * `@readonly` The length of the media in seconds that has been downloaded by the browser.
          * @inheritDoc
         */
        "buffered"?: number;
        /**
          * `@readonly` Whether playback has temporarily stopped because of a lack of temporary data.
          * @inheritDoc
         */
        "buffering"?: boolean;
        /**
          * Indicates whether a user interface should be shown for controlling the resource. Set this to `false` when you want to provide your own custom controls, and `true` if you want the current provider to supply its own default controls. Depending on the provider, changing this prop may cause the player to completely reset.
          * @inheritDoc
         */
        "controls"?: boolean;
        /**
          * `@readonly` The selected caption/subtitle text track to display. Defaults to `undefined` if there is none. This does not mean this track is active, only that is the current selection. To know if it is active, check the `isCaptionsActive` prop.
          * @inheritDoc
         */
        "currentCaption"?: TextTrack;
        /**
          * `@readonly` The absolute URL of the poster for the current media resource. Defaults to `undefined` if no media/poster has been loaded.
          * @inheritDoc
         */
        "currentPoster"?: string;
        /**
          * `@readonly` The current provider name whose responsible for loading and playing media. Defaults to `undefined` when no provider has been loaded.
          * @inheritDoc
         */
        "currentProvider"?: Provider;
        /**
          * `@readonly` The absolute URL of the media resource that has been chosen. Defaults to `undefined` if no media has been loaded.
          * @inheritDoc
         */
        "currentSrc"?: string;
        /**
          * A `double` indicating the current playback time in seconds. Defaults to `0` if the media has not started to play and has not seeked. Setting this value seeks the media to the new time. The value can be set to a minimum of `0` and maximum of the total length of the media (indicated by the duration prop).
          * @inheritDoc
         */
        "currentTime"?: number;
        /**
          * `@readonly` Whether the player is in debug mode and should `console.x` information about its internal state.
          * @inheritDoc
         */
        "debug"?: boolean;
        /**
          * `@readonly` A `double` indicating the total playback length of the media in seconds. Defaults to `-1` if no media has been loaded. If the media is being streamed live then the duration is equal to `Infinity`.
          * @inheritDoc
         */
        "duration"?: number;
        /**
          * `@readonly` A collection of errors that have occurred ordered by `[oldest, ..., newest]`.
          * @inheritDoc
         */
        "errors"?: any[];
        /**
          * `@readonly` A dictionary of translations for the current language.
          * @inheritDoc
         */
        "i18n"?: Translation;
        /**
          * `@readonly` Whether the current media is of type `audio`, shorthand for `mediaType === MediaType.Audio`.
          * @inheritDoc
         */
        "isAudio"?: boolean;
        /**
          * `@readonly` Whether the current view is of type `audio`, shorthand for `viewType === ViewType.Audio`.
          * @inheritDoc
         */
        "isAudioView"?: boolean;
        /**
          * `@readonly` Whether any captions or subtitles are currently showing.
          * @inheritDoc
         */
        "isCaptionsActive"?: boolean;
        /**
          * Whether the controls are currently visible. This is currently only supported by custom controls.
          * @inheritDoc
         */
        "isControlsActive"?: boolean;
        /**
          * `@readonly` Whether the player is currently in fullscreen mode.
          * @inheritDoc
         */
        "isFullscreenActive"?: boolean;
        /**
          * `@readonly` Whether the current media is being broadcast live (`duration === Infinity`).
          * @inheritDoc
         */
        "isLive"?: boolean;
        /**
          * `@readonly` Whether the player is in mobile mode. This is determined by parsing `window.navigator.userAgent`.
          * @inheritDoc
         */
        "isMobile"?: boolean;
        /**
          * `@readonly` Whether the player is currently in picture-in-picture mode.
          * @inheritDoc
         */
        "isPiPActive"?: boolean;
        /**
          * `@readonly` Whether the settings menu has been opened and is currently visible. This is currently only supported by custom settings.
          * @inheritDoc
         */
        "isSettingsActive"?: boolean;
        /**
          * `@readonly` Whether the player is in touch mode. This is determined by listening for mouse/touch events and toggling this value.
          * @inheritDoc
         */
        "isTouch"?: boolean;
        /**
          * `@readonly` Whether the current media is of type `video`, shorthand for `mediaType === MediaType.Video`.
          * @inheritDoc
         */
        "isVideo"?: boolean;
        /**
          * `@readonly` Whether the current view is of type `video`, shorthand for `viewType === ViewType.Video`.
          * @inheritDoc
         */
        "isVideoView"?: boolean;
        /**
          * The current language of the player. This can be any code defined via the `extendLanguage` method or the default `en`. It's recommended to use an ISO 639-1 code as that'll be used by Vime when adding new language defaults in the future.
          * @inheritDoc
         */
        "language"?: string;
        /**
          * `@readonly` The languages that are currently available. You can add new languages via the `extendLanguage` method.
          * @inheritDoc
         */
        "languages"?: string[];
        /**
          * Whether media should automatically start playing from the beginning every time it ends.
          * @inheritDoc
         */
        "loop"?: boolean;
        /**
          * `@readonly` The title of the current media. Defaults to `undefined` if no media has been loaded.
          * @inheritDoc
         */
        "mediaTitle"?: string;
        /**
          * `@readonly` The type of media that is currently active, whether it's audio or video. Defaults to `undefined` when no media has been loaded or the type cannot be determined.
          * @inheritDoc
         */
        "mediaType"?: MediaType;
        /**
          * Whether the audio is muted or not.
          * @inheritDoc
         */
        "muted"?: boolean;
        /**
          * Emitted when the player is attached/deattached from the DOM.
          * @inheritDoc
         */
        "onVAttachedChange"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when the `buffered` prop changes value.
          * @inheritDoc
         */
        "onVBufferedChange"?: (event: CustomEvent<PlayerProps['buffered']>) => void;
        /**
          * Emitted when the `buffering` prop changes value.
          * @inheritDoc
         */
        "onVBufferingChange"?: (event: CustomEvent<PlayerProps['buffering']>) => void;
        /**
          * Emitted when the `isControlsActive` prop changes value.
          * @inheritDoc
         */
        "onVControlsChange"?: (event: CustomEvent<PlayerProps['isControlsActive']>) => void;
        /**
          * Emitted when the `currentCaption` prop changes value.
          * @inheritdoc
         */
        "onVCurrentCaptionChange"?: (event: CustomEvent<PlayerProps['currentCaption']>) => void;
        /**
          * Emitted when the `currentPoster` prop changes value.
          * @inheritDoc
         */
        "onVCurrentPosterChange"?: (event: CustomEvent<PlayerProps['currentPoster']>) => void;
        /**
          * Emitted when the `currentProvider` prop changes value.
          * @inheritDoc
         */
        "onVCurrentProviderChange"?: (event: CustomEvent<PlayerProps['currentProvider']>) => void;
        /**
          * Emitted when the `currentSrc` prop changes value.
          * @inheritDoc
         */
        "onVCurrentSrcChange"?: (event: CustomEvent<PlayerProps['currentSrc']>) => void;
        /**
          * Emitted when the `currentTime` prop changes value.
          * @inheritDoc
         */
        "onVCurrentTimeChange"?: (event: CustomEvent<PlayerProps['currentTime']>) => void;
        /**
          * Emitted when the `duration` prop changes value.
          * @inheritDoc
         */
        "onVDurationChange"?: (event: CustomEvent<PlayerProps['duration']>) => void;
        /**
          * Emitted when the `errors` prop changes value.
          * @inheritDoc
         */
        "onVErrorsChange"?: (event: CustomEvent<PlayerProps['errors']>) => void;
        /**
          * Emitted when the `isFullscreenActive` prop changes value.
          * @inheritDoc
         */
        "onVFullscreenChange"?: (event: CustomEvent<PlayerProps['isFullscreenActive']>) => void;
        /**
          * Emitted when the `i18n` prop changes value.
          * @inheritdoc
         */
        "onVI18nChange"?: (event: CustomEvent<PlayerProps['i18n']>) => void;
        /**
          * Emitted when the `language` prop changes value.
          * @inheritDoc
         */
        "onVLanguageChange"?: (event: CustomEvent<PlayerProps['language']>) => void;
        /**
          * Emitted when the `languages` prop changes value.
          * @inheritDoc
         */
        "onVLanguagesChange"?: (event: CustomEvent<PlayerProps['languages']>) => void;
        /**
          * Emitted when the `isLive` prop changes value.
          * @inheritDoc
         */
        "onVLiveChange"?: (event: CustomEvent<PlayerProps['isLive']>) => void;
        /**
          * Emitted when the provider starts loading a media resource.
          * @inheritDoc
         */
        "onVLoadStart"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when the `mediaTitle` prop changes value.
          * @inheritDoc
         */
        "onVMediaTitleChange"?: (event: CustomEvent<PlayerProps['mediaTitle']>) => void;
        /**
          * Emitted when the `mediaType` prop changes value.
          * @inheritDoc
         */
        "onVMediaTypeChange"?: (event: CustomEvent<PlayerProps['mediaType']>) => void;
        /**
          * Emitted when the `muted` prop changes value.
          * @inheritDoc
         */
        "onVMutedChange"?: (event: CustomEvent<PlayerProps['muted']>) => void;
        /**
          * Emitted when the `paused` prop changes value.
          * @inheritDoc
         */
        "onVPausedChange"?: (event: CustomEvent<PlayerProps['paused']>) => void;
        /**
          * Emitted when the `isPiPActive` prop changes value.
          * @inheritDoc
         */
        "onVPiPChange"?: (event: CustomEvent<PlayerProps['isPiPActive']>) => void;
        /**
          * Emitted when the media is transitioning from `paused` to `playing`. Event flow: `paused` -> `play` -> `playing`. The media starts `playing` once enough content has buffered to begin/resume playback.
          * @inheritDoc
         */
        "onVPlay"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when playback reaches the end of the media.
          * @inheritDoc
         */
        "onVPlaybackEnded"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when the `playbackQualities` prop changes value.
          * @inheritDoc
         */
        "onVPlaybackQualitiesChange"?: (event: CustomEvent<PlayerProps['playbackQualities']>) => void;
        /**
          * Emitted when the `playbackQuality` prop changes value.
          * @inheritDoc
         */
        "onVPlaybackQualityChange"?: (event: CustomEvent<PlayerProps['playbackQuality']>) => void;
        /**
          * Emitted when the `playbackRate` prop changes value.
          * @inheritDoc
         */
        "onVPlaybackRateChange"?: (event: CustomEvent<PlayerProps['playbackRate']>) => void;
        /**
          * Emitted when the `playbackRates` prop changes value.
          * @inheritDoc
         */
        "onVPlaybackRatesChange"?: (event: CustomEvent<PlayerProps['playbackRates']>) => void;
        /**
          * Emitted when the media is ready to begin playback. The following props are guaranteed to be defined when this fires: `mediaTitle`, `currentSrc`, `currentPoster`, `duration`, `mediaType`, `viewType`.
          * @inheritDoc
         */
        "onVPlaybackReady"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when the media initiates playback.
          * @inheritDoc
         */
        "onVPlaybackStarted"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when the `playing` prop changes value.
          * @inheritDoc
         */
        "onVPlayingChange"?: (event: CustomEvent<PlayerProps['playing']>) => void;
        /**
          * Emitted when the player has loaded and is ready to be interacted with.
          * @inheritDoc
         */
        "onVReady"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted directly after the player has successfully transitioned/seeked to a new time position. Event flow: `seeking` -> `seeked`.
          * @inheritDoc
         */
        "onVSeeked"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when the `seeking` prop changes value.
          * @inheritDoc
         */
        "onVSeekingChange"?: (event: CustomEvent<PlayerProps['seeking']>) => void;
        /**
          * Emitted when the `textTracks` prop changes value.
          * @inheritDoc
         */
        "onVTextTracksChange"?: (event: CustomEvent<PlayerProps['textTracks']>) => void;
        /**
          * Emitted when the `theme` prop changes value.
          * @inheritDoc
         */
        "onVThemeChange"?: (event: CustomEvent<PlayerProps['theme']>) => void;
        /**
          * Emitted when the `isTouch` prop changes value.
          * @inheritDoc
         */
        "onVTouchChange"?: (event: CustomEvent<PlayerProps['isTouch']>) => void;
        /**
          * Emitted when the `translations` prop changes value.
          * @inheritdoc
         */
        "onVTranslationsChange"?: (event: CustomEvent<PlayerProps['translations']>) => void;
        /**
          * Emitted when the `viewType` prop changes value.
          * @inheritDoc
         */
        "onVViewTypeChange"?: (event: CustomEvent<PlayerProps['viewType']>) => void;
        /**
          * Emitted when the `volume` prop changes value.
          * @inheritDoc
         */
        "onVVolumeChange"?: (event: CustomEvent<PlayerProps['volume']>) => void;
        /**
          * Whether playback should be paused. Defaults to `true` if no media has loaded or playback has not started. Setting this to `true` will begin/resume playback.
          * @inheritDoc
         */
        "paused"?: boolean;
        /**
          * `@readonly` Whether media playback has reached the end. In other words it'll be true if `currentTime === duration`.
          * @inheritDoc
         */
        "playbackEnded"?: boolean;
        /**
          * `@readonly` The media qualities available for the current media.
          * @inheritDoc
         */
        "playbackQualities"?: string[];
        /**
          * Indicates the quality of the media. The value will differ between audio and video. For audio this might be some combination of the encoding format (AAC, MP3), bitrate in kilobits per second (kbps) and sample rate in kilohertz (kHZ). For video this will be the number of vertical pixels it supports. For example, if the video has a resolution of `1920x1080` then the quality will return `1080p`. Defaults to `undefined` which you can interpret as the quality is unknown. The quality can only be set to a quality found in the `playbackQualities` prop. Some providers may not allow changing the quality, you can check if it's possible via `canSetPlaybackQuality()`.
          * @inheritDoc
         */
        "playbackQuality"?: string;
        /**
          * A `double` indicating the rate at which media is being played back. If the value is `<1` then playback is slowed down; if `>1` then playback is sped up. Defaults to `1`. The playback rate can only be set to a rate found in the `playbackRates` prop. Some providers may not allow changing the playback rate, you can check if it's possible via `canSetPlaybackRate()`.
          * @inheritDoc
         */
        "playbackRate"?: number;
        /**
          * `@readonly` The playback rates available for the current media.
          * @inheritDoc
         */
        "playbackRates"?: number[];
        /**
          * `@readonly` Whether media is ready for playback to begin.
          * @inheritDoc
         */
        "playbackReady"?: boolean;
        /**
          * `@readonly` Whether the media has initiated playback. In other words it will be true if `currentTime > 0`.
          * @inheritDoc
         */
        "playbackStarted"?: boolean;
        /**
          * `@readonly` Whether media is actively playing back. Defaults to `false` if no media has loaded or playback has not started.
          * @inheritDoc
         */
        "playing"?: boolean;
        /**
          * Whether the video is to be played "inline", that is within the element's playback area. Note that setting this to false does not imply that the video will always be played in fullscreen. Depending on the provider, changing this prop may cause the player to completely reset.
          * @inheritDoc
         */
        "playsinline"?: boolean;
        /**
          * `@readonly` Whether the player has loaded and is ready to be interacted with.
          * @inheritDoc
         */
        "ready"?: boolean;
        /**
          * `@readonly` Whether the player is in the process of seeking to a new time position.
          * @inheritDoc
         */
        "seeking"?: boolean;
        /**
          * `@readonly` The text tracks (WebVTT) associated with the current media.
          * @inheritDoc
         */
        "textTracks"?: TextTrackList;
        /**
          * This property has no role other than scoping CSS selectors.
          * @inheritDoc
         */
        "theme"?: string;
        /**
          * `@readonly` Contains each language and its respective translation map.
          * @inheritDoc
         */
        "translations"?: Record<string, Translation>;
        /**
          * `@readonly` The type of player view that is being used, whether it's an audio player view or video player view. Normally if the media type is of audio then the view is of type audio, but in some cases it might be desirable to show a different view type. For example, when playing audio with a poster. This is subject to the provider allowing it. Defaults to `undefined` when no media has been loaded.
          * @inheritDoc
         */
        "viewType"?: ViewType;
        /**
          * An `int` between `0` (silent) and `100` (loudest) indicating the audio volume.
          * @inheritDoc
         */
        "volume"?: number;
    }
    interface VimePlayground {
        /**
          * The current poster to load.
         */
        "poster"?: string;
        /**
          * The current media provider.
         */
        "provider"?: Provider;
        /**
          * Whether to show the custom Vime UI or not.
         */
        "showCustomUI"?: boolean;
        /**
          * The current `src` to load into the provider.
         */
        "src"?: string;
        /**
          * The current custom UI theme, won't work if custom UI is turned off.
         */
        "theme"?: 'light' | 'dark';
    }
    interface VimePoster {
        /**
          * How the poster image should be resized to fit the container (sets the `object-fit` property).
         */
        "fit"?: 'fill' | 'contain' | 'cover' | 'scale-down' | 'none';
        /**
          * Emitted when the poster has loaded.
         */
        "onVLoaded"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when the poster will be hidden.
         */
        "onVWillHide"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when the poster will be shown.
         */
        "onVWillShow"?: (event: CustomEvent<void>) => void;
    }
    interface VimeScrim {
        /**
          * If this prop is defined, a dark gradient that smoothly fades out without being noticed will be used instead of a set color. This prop also sets the direction in which the dark end of the gradient should start. If the direction is set to `up`, the dark end of the gradient will start at the bottom of the player and fade out to the center. If the direction is set to `down`, the gradient will start at the top of the player and fade out to the center.
         */
        "gradient"?: 'up' | 'down';
    }
    interface VimeScrubberControl {
        /**
          * Whether the timestamp in the tooltip should show the hours unit, even if the time is less than 1 hour (eg: `20:35` -> `00:20:35`).
         */
        "alwaysShowHours"?: boolean;
        /**
          * Whether the tooltip should not be displayed.
         */
        "hideTooltip"?: boolean;
        /**
          * Prevents seeking forward/backward by using the Left/Right arrow keys.
         */
        "noKeyboard"?: boolean;
    }
    interface VimeSettings {
        /**
          * Whether the settings menu is opened/closed.
         */
        "active"?: boolean;
        /**
          * The height of any lower control bar in pixels so that the settings can re-position itself accordingly.
         */
        "controlsHeight"?: number;
        /**
          * Pins the settings to the defined position inside the video player. This has no effect when the view is of type `audio` (always `bottomRight`) and on mobile devices (always bottom sheet).
         */
        "pin"?: 'topLeft' | 'topRight' | 'bottomLeft' | 'bottomRight';
    }
    interface VimeSettingsControl {
        /**
          * Whether the settings menu this control manages is open.
         */
        "expanded"?: boolean;
        /**
          * The URL to an SVG element or fragment to load.
         */
        "icon"?: string;
        /**
          * The DOM `id` of the settings menu this control is responsible for opening/closing.
         */
        "menu"?: string;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection"?: TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition"?: TooltipPosition;
    }
    interface VimeSkeleton {
        /**
          * Determines which effect the skeleton will use.
         */
        "effect"?: 'sheen' | 'none';
    }
    interface VimeSlider {
        /**
          * A human-readable label for the purpose of the slider.
         */
        "label"?: string;
        /**
          * The greatest permitted value.
         */
        "max"?: number;
        /**
          * The lowest value in the range of permitted values.
         */
        "min"?: number;
        /**
          * Emitted when the value of the underlying `input` field changes.
         */
        "onVValueChange"?: (event: CustomEvent<number>) => void;
        /**
          * A number that specifies the granularity that the value must adhere to.
         */
        "step"?: number;
        /**
          * The current value.
         */
        "value"?: number;
        /**
          * Human-readable text alternative for the current value. Defaults to `value:max` percentage.
         */
        "valueText"?: string;
    }
    interface VimeSpinner {
        /**
          * Emitted when the spinner will be hidden.
         */
        "onVWillHide"?: (event: CustomEvent<void>) => void;
        /**
          * Emitted when the spinner will be shown.
         */
        "onVWillShow"?: (event: CustomEvent<void>) => void;
    }
    interface VimeSubmenu {
        /**
          * Whether the submenu is open/closed.
         */
        "active"?: boolean;
        /**
          * Whether the submenu should be displayed or not.
         */
        "hidden"?: boolean;
        /**
          * This can provide additional context about the current state of the submenu. For example, the hint could be the currently selected option if the submenu contains a radio group.
         */
        "hint"?: string;
        /**
          * The title of the submenu.
         */
        "label": string;
    }
    interface VimeTime {
        /**
          * Whether the time should always show the hours unit, even if the time is less than 1 hour (eg: `20:35` -> `00:20:35`).
         */
        "alwaysShowHours"?: boolean;
        /**
          * The `aria-label` property of the time.
         */
        "label": string;
        /**
          * The length of time in seconds.
         */
        "seconds"?: number;
    }
    interface VimeTimeProgress {
        /**
          * Whether the times should always show the hours unit, even if the time is less than 1 hour (eg: `20:35` -> `00:20:35`).
         */
        "alwaysShowHours"?: boolean;
        /**
          * The string used to separate the current time and end time.
         */
        "separator"?: string;
    }
    interface VimeTooltip {
        /**
          * Whether the tooltip is visible or not.
         */
        "active"?: boolean;
        /**
          * Determines if the tooltip should grow according to its contents to the left/right. By default content grows outwards from the center.
         */
        "direction"?: TooltipDirection;
        /**
          * Whether the tooltip is displayed or not.
         */
        "hidden"?: boolean;
        /**
          * Determines if the tooltip appears on top/bottom of it's parent.
         */
        "position"?: TooltipPosition;
    }
    interface VimeUi {
    }
    interface VimeVideo {
        /**
          * **EXPERIMENTAL:** Whether the browser should automatically toggle picture-in-picture mode as the user switches back and forth between this document and another document or application.
          * @inheritdoc
         */
        "autoPiP"?: boolean;
        /**
          * Determines what controls to show on the media element whenever the browser shows its own set of controls (e.g. when the controls attribute is specified).
          * @inheritdoc
         */
        "controlsList"?: string;
        /**
          * Whether to use CORS to fetch the related image. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/crossorigin) for more information.
          * @inheritdoc
         */
        "crossOrigin"?: MediaCrossOriginOption;
        /**
          * **EXPERIMENTAL:** Prevents the browser from suggesting a picture-in-picture context menu or to request picture-in-picture automatically in some cases.
          * @inheritdoc
         */
        "disablePiP"?: boolean;
        /**
          * **EXPERIMENTAL:** Whether to disable the capability of remote playback in devices that are attached using wired (HDMI, DVI, etc.) and wireless technologies (Miracast, Chromecast, DLNA, AirPlay, etc).
          * @inheritdoc
         */
        "disableRemotePlayback"?: boolean;
        /**
          * The title of the current media.
         */
        "mediaTitle"?: string;
        /**
          * A URL for an image to be shown while the video is downloading. If this attribute isn't specified, nothing is displayed until the first frame is available, then the first frame is shown as the poster frame.
          * @inheritdoc
         */
        "poster"?: string;
        /**
          * Provides a hint to the browser about what the author thinks will lead to the best user experience with regards to what content is loaded before the video is played. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload) for more information.
          * @inheritdoc
         */
        "preload"?: MediaPreloadOption;
    }
    interface VimeVimeo {
        /**
          * Whether to display the video owner's name.
         */
        "byline"?: boolean;
        /**
          * The hexadecimal color value of the playback controls. The embed settings of the video might override this value.
         */
        "color"?: string;
        /**
          * Turns off automatically determining the aspect ratio of the current video.
         */
        "noAutoAspectRatio"?: boolean;
        /**
          * Whether to display the video owner's portrait.
         */
        "portrait"?: boolean;
        /**
          * The absolute URL of a custom poster to be used for the current video.
         */
        "poster"?: string;
        /**
          * The Vimeo resource ID of the video to load.
         */
        "videoId": string;
    }
    interface VimeVolumeControl {
        /**
          * Whether the tooltip should be hidden.
         */
        "hideTooltip"?: boolean;
        /**
          * The URL to an SVG element or fragment.
         */
        "highVolumeIcon"?: string;
        /**
          * The URL to an SVG element or fragment.
         */
        "lowVolumeIcon"?: string;
        /**
          * A pipe (`/`) separated string of JS keyboard keys, that when caught in a `keydown` event, will toggle the muted state of the player.
         */
        "muteKeys"?: string;
        /**
          * The URL to an SVG element or fragment.
         */
        "mutedIcon"?: string;
        /**
          * Prevents the volume being changed using the Up/Down arrow keys.
         */
        "noKeyboard"?: boolean;
        /**
          * The direction in which the tooltip should grow.
         */
        "tooltipDirection"?: TooltipDirection;
        /**
          * Whether the tooltip is positioned above/below the control.
         */
        "tooltipPosition"?: TooltipPosition;
    }
    interface VimeYoutube {
        /**
          * Whether cookies should be enabled on the embed.
         */
        "cookies"?: boolean;
        /**
          * The absolute URL of a custom poster to be used for the current video.
         */
        "poster"?: string;
        /**
          * Whether the fullscreen control should be shown.
         */
        "showFullscreenControl"?: boolean;
        /**
          * The YouTube resource ID of the video to load.
         */
        "videoId": string;
    }
    interface IntrinsicElements {
        "vime-audio": VimeAudio;
        "vime-caption-control": VimeCaptionControl;
        "vime-captions": VimeCaptions;
        "vime-click-to-play": VimeClickToPlay;
        "vime-control": VimeControl;
        "vime-control-group": VimeControlGroup;
        "vime-control-spacer": VimeControlSpacer;
        "vime-controls": VimeControls;
        "vime-current-time": VimeCurrentTime;
        "vime-dailymotion": VimeDailymotion;
        "vime-dash": VimeDash;
        "vime-dbl-click-fullscreen": VimeDblClickFullscreen;
        "vime-default-controls": VimeDefaultControls;
        "vime-default-settings": VimeDefaultSettings;
        "vime-default-ui": VimeDefaultUi;
        "vime-embed": VimeEmbed;
        "vime-end-time": VimeEndTime;
        "vime-faketube": VimeFaketube;
        "vime-file": VimeFile;
        "vime-fullscreen-control": VimeFullscreenControl;
        "vime-hls": VimeHls;
        "vime-icon": VimeIcon;
        "vime-icons": VimeIcons;
        "vime-live-indicator": VimeLiveIndicator;
        "vime-menu": VimeMenu;
        "vime-menu-item": VimeMenuItem;
        "vime-menu-radio": VimeMenuRadio;
        "vime-menu-radio-group": VimeMenuRadioGroup;
        "vime-mute-control": VimeMuteControl;
        "vime-pip-control": VimePipControl;
        "vime-playback-control": VimePlaybackControl;
        "vime-player": VimePlayer;
        "vime-playground": VimePlayground;
        "vime-poster": VimePoster;
        "vime-scrim": VimeScrim;
        "vime-scrubber-control": VimeScrubberControl;
        "vime-settings": VimeSettings;
        "vime-settings-control": VimeSettingsControl;
        "vime-skeleton": VimeSkeleton;
        "vime-slider": VimeSlider;
        "vime-spinner": VimeSpinner;
        "vime-submenu": VimeSubmenu;
        "vime-time": VimeTime;
        "vime-time-progress": VimeTimeProgress;
        "vime-tooltip": VimeTooltip;
        "vime-ui": VimeUi;
        "vime-video": VimeVideo;
        "vime-vimeo": VimeVimeo;
        "vime-volume-control": VimeVolumeControl;
        "vime-youtube": VimeYoutube;
    }
}
export { LocalJSX as JSX };
declare module "@stencil/core" {
    export namespace JSX {
        interface IntrinsicElements {
            "vime-audio": LocalJSX.VimeAudio & JSXBase.HTMLAttributes<HTMLVimeAudioElement>;
            "vime-caption-control": LocalJSX.VimeCaptionControl & JSXBase.HTMLAttributes<HTMLVimeCaptionControlElement>;
            "vime-captions": LocalJSX.VimeCaptions & JSXBase.HTMLAttributes<HTMLVimeCaptionsElement>;
            "vime-click-to-play": LocalJSX.VimeClickToPlay & JSXBase.HTMLAttributes<HTMLVimeClickToPlayElement>;
            "vime-control": LocalJSX.VimeControl & JSXBase.HTMLAttributes<HTMLVimeControlElement>;
            "vime-control-group": LocalJSX.VimeControlGroup & JSXBase.HTMLAttributes<HTMLVimeControlGroupElement>;
            "vime-control-spacer": LocalJSX.VimeControlSpacer & JSXBase.HTMLAttributes<HTMLVimeControlSpacerElement>;
            "vime-controls": LocalJSX.VimeControls & JSXBase.HTMLAttributes<HTMLVimeControlsElement>;
            "vime-current-time": LocalJSX.VimeCurrentTime & JSXBase.HTMLAttributes<HTMLVimeCurrentTimeElement>;
            "vime-dailymotion": LocalJSX.VimeDailymotion & JSXBase.HTMLAttributes<HTMLVimeDailymotionElement>;
            "vime-dash": LocalJSX.VimeDash & JSXBase.HTMLAttributes<HTMLVimeDashElement>;
            "vime-dbl-click-fullscreen": LocalJSX.VimeDblClickFullscreen & JSXBase.HTMLAttributes<HTMLVimeDblClickFullscreenElement>;
            "vime-default-controls": LocalJSX.VimeDefaultControls & JSXBase.HTMLAttributes<HTMLVimeDefaultControlsElement>;
            "vime-default-settings": LocalJSX.VimeDefaultSettings & JSXBase.HTMLAttributes<HTMLVimeDefaultSettingsElement>;
            "vime-default-ui": LocalJSX.VimeDefaultUi & JSXBase.HTMLAttributes<HTMLVimeDefaultUiElement>;
            "vime-embed": LocalJSX.VimeEmbed & JSXBase.HTMLAttributes<HTMLVimeEmbedElement>;
            "vime-end-time": LocalJSX.VimeEndTime & JSXBase.HTMLAttributes<HTMLVimeEndTimeElement>;
            "vime-faketube": LocalJSX.VimeFaketube & JSXBase.HTMLAttributes<HTMLVimeFaketubeElement>;
            "vime-file": LocalJSX.VimeFile & JSXBase.HTMLAttributes<HTMLVimeFileElement>;
            "vime-fullscreen-control": LocalJSX.VimeFullscreenControl & JSXBase.HTMLAttributes<HTMLVimeFullscreenControlElement>;
            "vime-hls": LocalJSX.VimeHls & JSXBase.HTMLAttributes<HTMLVimeHlsElement>;
            "vime-icon": LocalJSX.VimeIcon & JSXBase.HTMLAttributes<HTMLVimeIconElement>;
            "vime-icons": LocalJSX.VimeIcons & JSXBase.HTMLAttributes<HTMLVimeIconsElement>;
            "vime-live-indicator": LocalJSX.VimeLiveIndicator & JSXBase.HTMLAttributes<HTMLVimeLiveIndicatorElement>;
            "vime-menu": LocalJSX.VimeMenu & JSXBase.HTMLAttributes<HTMLVimeMenuElement>;
            "vime-menu-item": LocalJSX.VimeMenuItem & JSXBase.HTMLAttributes<HTMLVimeMenuItemElement>;
            "vime-menu-radio": LocalJSX.VimeMenuRadio & JSXBase.HTMLAttributes<HTMLVimeMenuRadioElement>;
            "vime-menu-radio-group": LocalJSX.VimeMenuRadioGroup & JSXBase.HTMLAttributes<HTMLVimeMenuRadioGroupElement>;
            "vime-mute-control": LocalJSX.VimeMuteControl & JSXBase.HTMLAttributes<HTMLVimeMuteControlElement>;
            "vime-pip-control": LocalJSX.VimePipControl & JSXBase.HTMLAttributes<HTMLVimePipControlElement>;
            "vime-playback-control": LocalJSX.VimePlaybackControl & JSXBase.HTMLAttributes<HTMLVimePlaybackControlElement>;
            "vime-player": LocalJSX.VimePlayer & JSXBase.HTMLAttributes<HTMLVimePlayerElement>;
            "vime-playground": LocalJSX.VimePlayground & JSXBase.HTMLAttributes<HTMLVimePlaygroundElement>;
            "vime-poster": LocalJSX.VimePoster & JSXBase.HTMLAttributes<HTMLVimePosterElement>;
            "vime-scrim": LocalJSX.VimeScrim & JSXBase.HTMLAttributes<HTMLVimeScrimElement>;
            "vime-scrubber-control": LocalJSX.VimeScrubberControl & JSXBase.HTMLAttributes<HTMLVimeScrubberControlElement>;
            "vime-settings": LocalJSX.VimeSettings & JSXBase.HTMLAttributes<HTMLVimeSettingsElement>;
            "vime-settings-control": LocalJSX.VimeSettingsControl & JSXBase.HTMLAttributes<HTMLVimeSettingsControlElement>;
            "vime-skeleton": LocalJSX.VimeSkeleton & JSXBase.HTMLAttributes<HTMLVimeSkeletonElement>;
            "vime-slider": LocalJSX.VimeSlider & JSXBase.HTMLAttributes<HTMLVimeSliderElement>;
            "vime-spinner": LocalJSX.VimeSpinner & JSXBase.HTMLAttributes<HTMLVimeSpinnerElement>;
            "vime-submenu": LocalJSX.VimeSubmenu & JSXBase.HTMLAttributes<HTMLVimeSubmenuElement>;
            "vime-time": LocalJSX.VimeTime & JSXBase.HTMLAttributes<HTMLVimeTimeElement>;
            "vime-time-progress": LocalJSX.VimeTimeProgress & JSXBase.HTMLAttributes<HTMLVimeTimeProgressElement>;
            "vime-tooltip": LocalJSX.VimeTooltip & JSXBase.HTMLAttributes<HTMLVimeTooltipElement>;
            "vime-ui": LocalJSX.VimeUi & JSXBase.HTMLAttributes<HTMLVimeUiElement>;
            "vime-video": LocalJSX.VimeVideo & JSXBase.HTMLAttributes<HTMLVimeVideoElement>;
            "vime-vimeo": LocalJSX.VimeVimeo & JSXBase.HTMLAttributes<HTMLVimeVimeoElement>;
            "vime-volume-control": LocalJSX.VimeVolumeControl & JSXBase.HTMLAttributes<HTMLVimeVolumeControlElement>;
            "vime-youtube": LocalJSX.VimeYoutube & JSXBase.HTMLAttributes<HTMLVimeYoutubeElement>;
        }
    }
}
