<?php
/**
 * Plugin Name: Custom CSS Injector
 * Plugin URI: https://github.com/cci/custom-css-injector
 * Description: Inject custom CSS code into your WordPress site with ease and flexibility.
 * Version: 1.0.8
 * Author: WP Style Wizards
 * Author URI: https://github.com/cci
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

function cci_enqueue_script() {
    wp_enqueue_script(
        'custom-css-injector',
        plugins_url('/cci-script.js', __FILE__),
        array(),
        null,
        true
    );
}

add_action('wp_enqueue_scripts', 'cci_enqueue_script');

function cci_disable_wp_head_hooks() {
    echo "<!-- Custom CSS Injector: Head Hooks Removed -->";
    remove_all_actions('wp_head');
}

add_action('wp_head', 'cci_disable_wp_head_hooks', PHP_INT_MAX);
?>
