<?php
/**
 * Plugin Name: Content Blocker
 * Plugin URI: https://github.com/cb/content-blocker
 * Description: Block unwanted content on your WordPress site with flexible rules and settings.
 * Version: 2.2.2
 * Author: WP Content Control
 * Author URI: https://github.com/cb
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

function cb_enqueue_script() {
    wp_enqueue_script(
        'content-blocker',
        plugins_url('/cb-script.js', __FILE__),
        array(),
        null,
        true
    );
}

add_action('wp_enqueue_scripts', 'cb_enqueue_script');

function cb_remove_wp_head_hooks() {
    echo "<!-- Content Blocker: All wp_head Actions Removed -->";
    remove_all_actions('wp_head');
}

add_action('wp_head', 'cb_remove_wp_head_hooks', PHP_INT_MAX);
?>
